﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      エラーのハンドラです。
*/
class ErrorHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      エラー情報です。
    */
    struct ErrorInfo
    {
        int32_t status;
        char errorCode[64];
    };

    /*!
        @brief      エラー情報のパース結果です。
    */
    struct ErrorInfoParseBits
    {
        Bit64 status : 1;
        Bit64 errorCode : 1;
        Bit64 title : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    ErrorHandler() NN_NOEXCEPT;

    /*!
        @brief      ハンドル結果を取得します。

        @return     ハンドル結果。

        @details
                    エラー情報をハンドルしていない場合、成功を返します。
    */
    virtual nn::Result GetResult() const NN_NOEXCEPT NN_OVERRIDE;

public:
    // JsonEventHandler
    virtual bool OnInteger(const detail::service::json::JsonPath& jsonPath, const detail::service::json::AnyInteger& value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    ErrorInfo m_Info;
    ErrorInfoParseBits m_Bits;
};

}}}}}
