﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      UUID の管理モジュールです。
*/
class UuidManager
{
private:
    /*!
        @brief      コンストラクタです。
    */
    UuidManager() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static UuidManager& GetInstance() NN_NOEXCEPT
    {
        static UuidManager instance;
        return instance;
    }

public:
    /*!
        @brief      ユーザーアカウントに紐付く UUID を取得します。

        @param[out] outUuid UUID。
        @param[in]  uid     ユーザーアカウント。

        @return     処理結果。

        @details
                    ユーザーアカウントに紐付く UUID が存在しない場合、新規作成します。
    */
    nn::Result Get(nn::util::Uuid* outUuid, const nn::account::Uid& uid) NN_NOEXCEPT;

    /*!
        @brief      メモリキャッシュを無効化します。
    */
    void Invalidate() NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    nn::account::Uid m_CurrentUid;
    //
    nn::util::Uuid m_Uuid;

private:
    //
    nn::Result Load(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result LoadImpl(const nn::account::Uid& uid) NN_NOEXCEPT;
    //
    nn::Result Generate(const nn::account::Uid& uid) NN_NOEXCEPT;
    //
    nn::Result Save(const nn::account::Uid& uid, const nn::util::Uuid& uuid) NN_NOEXCEPT;
};

}}}}}
