﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>
#include <curl/curl.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      プロフィール画像のダウンローダーです。
*/
class ImageDownloader
{
public:
    /*!
        @brief      コンストラクタです。
    */
    ImageDownloader() NN_NOEXCEPT;

    /*!
        @brief      キャンセル可能オブジェクトを設定します。

        @param[in]  cancelable  キャンセル可能オブジェクト。
    */
    void SetCancelable(const detail::service::util::Cancelable* cancelable) NN_NOEXCEPT;

    /*!
        @brief      プロフィール画像のダウンロードを行います。

        @param[in]  url     URL。
        @param[in]  buffer  受信バッファ。
        @param[in]  size    受信バッファサイズ。

        @pre
            - url != nullptr
            - buffer != nullptr
            - size > 0

        @return     処理結果。
    */
    nn::Result Perform(const char* url, void* buffer, size_t size) NN_NOEXCEPT;

    /*!
        @brief      ダウンロードしたプロフィール画像のサイズを取得します。

        @return     サイズ。

        @details
                    本関数は、ダウンロード処理後に呼び出してください。
    */
    size_t GetDownloadedSize() const NN_NOEXCEPT;

private:
    /*!
        @brief      HTTP 関数に渡すパラメータです。
    */
    struct HttpFunctionParam
    {
        Bit8* buffer;
        size_t bufferSize;
        size_t downloadedSize;
        bool is200Ok;
        bool isJpeg;
    };

private:
    //
    const detail::service::util::Cancelable* m_Cancelable;
    //
    size_t m_DownloadedSize;

private:
    //
    nn::Result PerformImpl(CURLM* multi) NN_NOEXCEPT;

private:
    //
    static CURLcode SslCtxFunction(CURL* curl, void* ssl, void* param) NN_NOEXCEPT;
    //
    static size_t HttpHeaderFunction(char* buffer, size_t size, size_t count, void* param) NN_NOEXCEPT;
    //
    static size_t HttpWriteFunction(char* buffer, size_t size, size_t count, void* param) NN_NOEXCEPT;
};

}}}}}
