﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_FriendRequest.h>
#include <nn/friends/detail/friends_TypesDetail.h>
#include <nn/friends/detail/friends_MacrosImpl.h>

namespace nn { namespace friends { namespace detail {

NN_DETAIL_FRIENDS_BEGIN_IMPL(FriendRequest)
{
    // 16
    nn::account::Uid uid;
    // 8
    RequestId requestId;
    // 8
    nn::account::NetworkServiceAccountId accountId;
    // 40
    nn::account::Nickname nickname;
    char nicknamePadding[7];
    // 160
    Url profileImageUrl;
    // 4
    int32_t requestListType;
    // 4
    int32_t requestType;
    // 4
    int32_t requestStatus;
    // 4
    NN_PADDING4;
    // 96
    RouteInfo routeInfo;
    // 1
    bool read;
    // 1
    bool isValid;
    // 6
    NN_PADDING6;
    // 48
    RouteInfoExtra routeInfoExtra;
}
NN_DETAIL_FRIENDS_END_IMPL(FriendRequest);

}}}
