﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      fgm モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_FGM_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_FGM_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_FGM_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_FGM_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_FGM_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_FGM_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_FGM_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_FGM_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_FGM_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_FGM_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_FGM_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_FGM_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_FGM_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_FGM_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_FGM_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_FGM_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_FGM_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_FGM_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_FGM_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_FGM_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fgm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_FGM_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Trace, 0, format, args)
#define NN_DETAIL_FGM_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Trace, 1, format, args)
#define NN_DETAIL_FGM_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Trace, 2, format, args)
#define NN_DETAIL_FGM_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Trace, 3, format, args)

#define NN_DETAIL_FGM_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Info, 0, format, args)
#define NN_DETAIL_FGM_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Info, 1, format, args)
#define NN_DETAIL_FGM_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Info, 2, format, args)
#define NN_DETAIL_FGM_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Info, 3, format, args)

#define NN_DETAIL_FGM_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Warn, 0, format, args)
#define NN_DETAIL_FGM_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Warn, 1, format, args)
#define NN_DETAIL_FGM_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Warn, 2, format, args)
#define NN_DETAIL_FGM_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Warn, 3, format, args)

#define NN_DETAIL_FGM_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Error, 0, format, args)
#define NN_DETAIL_FGM_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Error, 1, format, args)
#define NN_DETAIL_FGM_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Error, 2, format, args)
#define NN_DETAIL_FGM_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Error, 3, format, args)

#define NN_DETAIL_FGM_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Fatal, 0, format, args)
#define NN_DETAIL_FGM_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Fatal, 1, format, args)
#define NN_DETAIL_FGM_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Fatal, 2, format, args)
#define NN_DETAIL_FGM_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fgm, Fatal, 3, format, args)

#define NN_DETAIL_FGM_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Trace, 0, text, length)
#define NN_DETAIL_FGM_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Trace, 1, text, length)
#define NN_DETAIL_FGM_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Trace, 2, text, length)
#define NN_DETAIL_FGM_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Trace, 3, text, length)

#define NN_DETAIL_FGM_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Info, 0, text, length)
#define NN_DETAIL_FGM_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Info, 1, text, length)
#define NN_DETAIL_FGM_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Info, 2, text, length)
#define NN_DETAIL_FGM_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Info, 3, text, length)

#define NN_DETAIL_FGM_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Warn, 0, text, length)
#define NN_DETAIL_FGM_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Warn, 1, text, length)
#define NN_DETAIL_FGM_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Warn, 2, text, length)
#define NN_DETAIL_FGM_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Warn, 3, text, length)

#define NN_DETAIL_FGM_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Error, 0, text, length)
#define NN_DETAIL_FGM_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Error, 1, text, length)
#define NN_DETAIL_FGM_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Error, 2, text, length)
#define NN_DETAIL_FGM_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Error, 3, text, length)

#define NN_DETAIL_FGM_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Fatal, 0, text, length)
#define NN_DETAIL_FGM_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Fatal, 1, text, length)
#define NN_DETAIL_FGM_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Fatal, 2, text, length)
#define NN_DETAIL_FGM_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fgm, Fatal, 3, text, length)

namespace nn { namespace fgm { namespace detail {

inline void WarnUnlessResultSuccessImpl(const char* pStringizedExpression, const Result& result) NN_NOEXCEPT
{
    if ( result.IsFailure() )
    {
        NN_DETAIL_FGM_WARN("Failed: %s\n  Module: %d\n  Description: %d\n  InnerValue: 0x%08x\n",
            pStringizedExpression, result.GetModule(), result.GetDescription(), result.GetInnerValueForDebug());
    }
}

}}} // namespace nn::fgm::detail

#define NN_DETAIL_FGM_WARN_UNLESS_RESULT_SUCCESS(expression) \
    nn::fgm::detail::WarnUnlessResultSuccessImpl(NN_MACRO_STRINGIZE(expression), (expression))
