﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_SystemEvent.h>

namespace nn { namespace fatalsrv {
    class FatalEventManager
    {
        NN_DISALLOW_COPY(FatalEventManager);
    public:
        static const int MaxEventCount = 3;

        FatalEventManager() NN_NOEXCEPT;
        void Signal() NN_NOEXCEPT;
        Result GetEvent(os::SystemEvent** out) NN_NOEXCEPT;
    private:
        int m_CurrentCount;
        os::SystemEvent* m_Events[MaxEventCount];
        os::Mutex m_Lock;
    };

}} //namespace nn::fatalsrv
