﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_BitFlagSet.h>
#include <nn/fatalsrv/detail/fatalsrv_Aarch64Context.h>
#include <nn/fatalsrv/detail/fatalsrv_Aarch32Context.h>
#include <string>

namespace nn { namespace fatalsrv {

    struct CpuContext
    {
        enum ArchType {
            Aarch64 = 0,
            Aarch32 = 1,
        };

        union
        {
            Aarch64Context  aarch64;
            Aarch32Context  aarch32;
        };

        ArchType archType;
        Bit32 exceptionType;
        void Clear() NN_NOEXCEPT
        {
            std::memset(this, 0, sizeof(*this));
        }
    };

    NN_STATIC_ASSERT(std::is_pod<CpuContext>::value);
}} // namespace nn::fatalsrv
