﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fatal/fatal_FatalPolicy.h>

namespace nn { namespace fatal {
    /**
    *   @brief      Fatal 発生時の動作ポリシーを設定します。
    *   @details    自プロセスが Fatal を発生させてしまった場合の、Fatal の動作ポリシーを変更することができます。
    *               自プロセスが Fatal を発生させるよりも以前に呼び出す必要があるので、基本的にはプログラムの冒頭で呼び出すようにしてください。
    *               デフォルトでは Fatal 画面の表示等を行い最終的に全てのコアの停止が行われますが、
    *               FatalPolicy_OnlyErrorReport を設定すると、エラーレポートの作成だけを行い Fatal 処理を抜けます。
    *
    *   @param[in]  policy  動作ポリシー
    */
    void SetFatalPolicy(FatalPolicy policy) NN_NOEXCEPT;
}} // namespace nn::fatal
