﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      fan モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_FAN_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(fan, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_FAN_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fan, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_FAN_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fan, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_FAN_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fan, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_FAN_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(fan, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_FAN_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fan, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_FAN_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fan, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_FAN_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fan, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_FAN_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(fan, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_FAN_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fan, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_FAN_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fan, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_FAN_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(fan, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_FAN_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(fan, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_FAN_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fan, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_FAN_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fan, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_FAN_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fan, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_FAN_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(fan, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_FAN_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fan, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_FAN_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fan, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_FAN_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(fan, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_FAN_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Trace, 0, format, args)
#define NN_DETAIL_FAN_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Trace, 1, format, args)
#define NN_DETAIL_FAN_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Trace, 2, format, args)
#define NN_DETAIL_FAN_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Trace, 3, format, args)

#define NN_DETAIL_FAN_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Info, 0, format, args)
#define NN_DETAIL_FAN_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Info, 1, format, args)
#define NN_DETAIL_FAN_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Info, 2, format, args)
#define NN_DETAIL_FAN_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Info, 3, format, args)

#define NN_DETAIL_FAN_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Warn, 0, format, args)
#define NN_DETAIL_FAN_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Warn, 1, format, args)
#define NN_DETAIL_FAN_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Warn, 2, format, args)
#define NN_DETAIL_FAN_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Warn, 3, format, args)

#define NN_DETAIL_FAN_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Error, 0, format, args)
#define NN_DETAIL_FAN_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Error, 1, format, args)
#define NN_DETAIL_FAN_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Error, 2, format, args)
#define NN_DETAIL_FAN_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Error, 3, format, args)

#define NN_DETAIL_FAN_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Fatal, 0, format, args)
#define NN_DETAIL_FAN_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Fatal, 1, format, args)
#define NN_DETAIL_FAN_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Fatal, 2, format, args)
#define NN_DETAIL_FAN_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(fan, Fatal, 3, format, args)

#define NN_DETAIL_FAN_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(fan, Trace, 0, text, length)
#define NN_DETAIL_FAN_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fan, Trace, 1, text, length)
#define NN_DETAIL_FAN_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fan, Trace, 2, text, length)
#define NN_DETAIL_FAN_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fan, Trace, 3, text, length)

#define NN_DETAIL_FAN_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(fan, Info, 0, text, length)
#define NN_DETAIL_FAN_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fan, Info, 1, text, length)
#define NN_DETAIL_FAN_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fan, Info, 2, text, length)
#define NN_DETAIL_FAN_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fan, Info, 3, text, length)

#define NN_DETAIL_FAN_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(fan, Warn, 0, text, length)
#define NN_DETAIL_FAN_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fan, Warn, 1, text, length)
#define NN_DETAIL_FAN_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fan, Warn, 2, text, length)
#define NN_DETAIL_FAN_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(fan, Warn, 3, text, length)

#define NN_DETAIL_FAN_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(fan, Error, 0, text, length)
#define NN_DETAIL_FAN_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fan, Error, 1, text, length)
#define NN_DETAIL_FAN_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fan, Error, 2, text, length)
#define NN_DETAIL_FAN_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fan, Error, 3, text, length)

#define NN_DETAIL_FAN_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(fan, Fatal, 0, text, length)
#define NN_DETAIL_FAN_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fan, Fatal, 1, text, length)
#define NN_DETAIL_FAN_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fan, Fatal, 2, text, length)
#define NN_DETAIL_FAN_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(fan, Fatal, 3, text, length)
