﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <nn/fan/fan_ControlTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace fan { namespace detail { // NOLINT(whitespace/braces)

class IController;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IController, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IController)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetRotationSpeedLevel, (::nn::fan::RotationSpeedLevel level))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetRotationSpeedLevelByDiff, (::nn::sf::Out<::nn::fan::RotationSpeedLevel> newLevel, ::nn::fan::RotationSpeedLevel levelDiff))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRotationSpeedLevel, (::nn::sf::Out<::nn::fan::RotationSpeedLevel> level))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetRotationRate, (int rotationRate))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRotationRate, (::nn::sf::Out<int> rotationRate))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EnableFan)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DisableFan)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActualRotationSpeedLevel, (::nn::sf::Out<::nn::fan::RotationSpeedLevel> level))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IController)

        ::nn::Result SetRotationSpeedLevel(::nn::fan::RotationSpeedLevel level) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetRotationSpeedLevel, (level));
        }

        ::nn::Result SetRotationSpeedLevelByDiff(::nn::sf::Out<::nn::fan::RotationSpeedLevel> newLevel, ::nn::fan::RotationSpeedLevel levelDiff) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetRotationSpeedLevelByDiff, (newLevel, levelDiff));
        }

        ::nn::Result GetRotationSpeedLevel(::nn::sf::Out<::nn::fan::RotationSpeedLevel> level) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRotationSpeedLevel, (level));
        }

        ::nn::Result SetRotationRate(int rotationRate) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetRotationRate, (rotationRate));
        }

        ::nn::Result GetRotationRate(::nn::sf::Out<int> rotationRate) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRotationRate, (rotationRate));
        }

        ::nn::Result EnableFan() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EnableFan);
        }

        ::nn::Result DisableFan() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DisableFan);
        }

        ::nn::Result GetActualRotationSpeedLevel(::nn::sf::Out<::nn::fan::RotationSpeedLevel> level) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActualRotationSpeedLevel, (level));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IController
    {
    public:
        nn::Result SetRotationSpeedLevel(nn::fan::RotationSpeedLevel level) NN_NOEXCEPT;
        nn::Result SetRotationSpeedLevelByDiff(nn::sf::Out<nn::fan::RotationSpeedLevel> newLevel, nn::fan::RotationSpeedLevel levelDiff) NN_NOEXCEPT;
        nn::Result GetRotationSpeedLevel(nn::sf::Out<nn::fan::RotationSpeedLevel> level) NN_NOEXCEPT;
        nn::Result SetRotationRate(int rotationRate) NN_NOEXCEPT;
        nn::Result GetRotationRate(nn::sf::Out<int> rotationRate) NN_NOEXCEPT;
        nn::Result EnableFan() NN_NOEXCEPT;
        nn::Result DisableFan() NN_NOEXCEPT;
        nn::Result GetActualRotationSpeedLevel(nn::sf::Out<nn::fan::RotationSpeedLevel> level) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SetRotationSpeedLevel(nn::fan::RotationSpeedLevel level) NN_NOEXCEPT;
    nn::Result SetRotationSpeedLevelByDiff(nn::sf::Out<nn::fan::RotationSpeedLevel> newLevel, nn::fan::RotationSpeedLevel levelDiff) NN_NOEXCEPT;
    nn::Result GetRotationSpeedLevel(nn::sf::Out<nn::fan::RotationSpeedLevel> level) NN_NOEXCEPT;
    nn::Result SetRotationRate(int rotationRate) NN_NOEXCEPT;
    nn::Result GetRotationRate(nn::sf::Out<int> rotationRate) NN_NOEXCEPT;
    nn::Result EnableFan() NN_NOEXCEPT;
    nn::Result DisableFan() NN_NOEXCEPT;
    nn::Result GetActualRotationSpeedLevel(nn::sf::Out<nn::fan::RotationSpeedLevel> level) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::fan::detail::IController))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRotationSpeedLevel, (::nn::fan::RotationSpeedLevel level))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetRotationSpeedLevel, (level));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRotationSpeedLevelByDiff, (::nn::sf::Out<::nn::fan::RotationSpeedLevel> newLevel, ::nn::fan::RotationSpeedLevel levelDiff))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetRotationSpeedLevelByDiff, (newLevel, levelDiff));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRotationSpeedLevel, (::nn::sf::Out<::nn::fan::RotationSpeedLevel> level))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRotationSpeedLevel, (level));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRotationRate, (int rotationRate))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetRotationRate, (rotationRate));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRotationRate, (::nn::sf::Out<int> rotationRate))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRotationRate, (rotationRate));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableFan)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EnableFan);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableFan)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DisableFan);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActualRotationSpeedLevel, (::nn::sf::Out<::nn::fan::RotationSpeedLevel> level))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActualRotationSpeedLevel, (level));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::fan::detail::IController>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::fan::detail::IController))

    // nn::Result SetRotationSpeedLevel(nn::fan::RotationSpeedLevel level) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetRotationSpeedLevel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(level, (::nn::fan::RotationSpeedLevel), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (level))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(level)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetRotationSpeedLevel)

    // nn::Result SetRotationSpeedLevelByDiff(nn::sf::Out<nn::fan::RotationSpeedLevel> newLevel, nn::fan::RotationSpeedLevel levelDiff) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetRotationSpeedLevelByDiff)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(levelDiff, (::nn::fan::RotationSpeedLevel), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (levelDiff))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(newLevel, (::nn::fan::RotationSpeedLevel), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (newLevel))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(newLevel), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(levelDiff)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetRotationSpeedLevelByDiff)

    // nn::Result GetRotationSpeedLevel(nn::sf::Out<nn::fan::RotationSpeedLevel> level) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRotationSpeedLevel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(level, (::nn::fan::RotationSpeedLevel), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (level))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(level)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRotationSpeedLevel)

    // nn::Result SetRotationRate(int rotationRate) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetRotationRate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rotationRate, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rotationRate))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rotationRate)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetRotationRate)

    // nn::Result GetRotationRate(nn::sf::Out<int> rotationRate) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRotationRate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(rotationRate, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (rotationRate))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rotationRate)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRotationRate)

    // nn::Result EnableFan() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableFan)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableFan)

    // nn::Result DisableFan() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableFan)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableFan)

    // nn::Result GetActualRotationSpeedLevel(nn::sf::Out<nn::fan::RotationSpeedLevel> level) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActualRotationSpeedLevel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(level, (::nn::fan::RotationSpeedLevel), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (level))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(level)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActualRotationSpeedLevel)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fan::RotationSpeedLevel), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::fan::detail::IController, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::fan::detail::IController))

    // nn::Result SetRotationSpeedLevel(nn::fan::RotationSpeedLevel level) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRotationSpeedLevel, (::nn::fan::RotationSpeedLevel level))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetRotationSpeedLevel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(level)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetRotationSpeedLevel)
    }

    // nn::Result SetRotationSpeedLevelByDiff(nn::sf::Out<nn::fan::RotationSpeedLevel> newLevel, nn::fan::RotationSpeedLevel levelDiff) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRotationSpeedLevelByDiff, (::nn::sf::Out<::nn::fan::RotationSpeedLevel> newLevel, ::nn::fan::RotationSpeedLevel levelDiff))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetRotationSpeedLevelByDiff)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(newLevel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(levelDiff)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetRotationSpeedLevelByDiff)
    }

    // nn::Result GetRotationSpeedLevel(nn::sf::Out<nn::fan::RotationSpeedLevel> level) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRotationSpeedLevel, (::nn::sf::Out<::nn::fan::RotationSpeedLevel> level))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRotationSpeedLevel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(level)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRotationSpeedLevel)
    }

    // nn::Result SetRotationRate(int rotationRate) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRotationRate, (int rotationRate))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetRotationRate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rotationRate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetRotationRate)
    }

    // nn::Result GetRotationRate(nn::sf::Out<int> rotationRate) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRotationRate, (::nn::sf::Out<int> rotationRate))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRotationRate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rotationRate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRotationRate)
    }

    // nn::Result EnableFan() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableFan)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableFan)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableFan)
    }

    // nn::Result DisableFan() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableFan)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableFan)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableFan)
    }

    // nn::Result GetActualRotationSpeedLevel(nn::sf::Out<nn::fan::RotationSpeedLevel> level) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActualRotationSpeedLevel, (::nn::sf::Out<::nn::fan::RotationSpeedLevel> level))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActualRotationSpeedLevel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(level)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActualRotationSpeedLevel)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::fan::detail::IController>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::fan::detail::IController))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetRotationSpeedLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetRotationSpeedLevel)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(level)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetRotationSpeedLevelByDiff)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetRotationSpeedLevelByDiff)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(newLevel),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(levelDiff)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRotationSpeedLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRotationSpeedLevel)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(level)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetRotationRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetRotationRate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rotationRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRotationRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRotationRate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(rotationRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableFan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableFan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableFan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableFan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActualRotationSpeedLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActualRotationSpeedLevel)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(level)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetRotationSpeedLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetRotationSpeedLevelByDiff)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRotationSpeedLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetRotationRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRotationRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableFan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableFan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActualRotationSpeedLevel)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::fan::detail::IController))
