﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/es/es_RightsTypes.h>

namespace nn { namespace es {

/*!
* @brief ELicenseOwnerId を表す構造体です。
*/
struct ELicenseOwnerId
{
    uint64_t id;
};

const ELicenseOwnerId InvalidELicenseOwnerId = { 0 };

inline ELicenseOwnerId GetELicenseOwnerId(const RightsStatus& rightsStatus) NN_NOEXCEPT
{
    return { rightsStatus.rights._eLicenseOwnerIdValue };
}

ELicenseOwnerId GetELicenseOwnerId(const account::NintendoAccountId& naId) NN_NOEXCEPT;

account::NintendoAccountId GetNintendoAccountId(const ELicenseOwnerId& eLicenseOwnerId) NN_NOEXCEPT;

inline bool operator == (const ELicenseOwnerId& lhs, const ELicenseOwnerId& rhs) NN_NOEXCEPT
{
    return lhs.id == rhs.id;
}
inline bool operator != (const ELicenseOwnerId& lhs, const ELicenseOwnerId& rhs) NN_NOEXCEPT
{
    return ! (lhs == rhs);
}

/*!
* @brief ELicenseUserId を表す構造体です。
*/
struct ELicenseUserId
{
    uint64_t id;
};

const ELicenseUserId InvalidELicenseUserId = { 0 };

ELicenseUserId GetELicenseUserId(const account::NintendoAccountId& naId) NN_NOEXCEPT;

account::NintendoAccountId GetNintendoAccountId(const ELicenseUserId& eLicenseOwnerId) NN_NOEXCEPT;

inline bool operator == (const ELicenseUserId& lhs, const ELicenseUserId& rhs) NN_NOEXCEPT
{
    return lhs.id == rhs.id;
}
inline bool operator != (const ELicenseUserId& lhs, const ELicenseUserId& rhs) NN_NOEXCEPT
{
    return ! (lhs == rhs);
}

}}
