﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  eTicketService のローカルでの同時利用判定に関する型や定数の宣言
*/

#pragma once

namespace nn { namespace es {

/*!
* @brief ローカルでの同時利用判定のためのチャレンジを表す構造体です。
*/
struct LocalConcurrencyCheckChallenge
{
    uint64_t value;
};

/*!
* @brief ローカルでの同時利用判定のための権利利用情報を表す構造体です。
*/
struct LocalConcurrencyCheckData
{
    uint8_t data[768];
};

/*!
* @brief ローカルでの同時利用判定のための認証情報を表す構造体です。
*/
struct LocalConcurrencyCheckAuthenticationInfo
{
    uint8_t data[256];
};

}}
