﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  eTicketService の初期化に関する API
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace es {

/**
* @brief    es ライブラリ初期化処理を行います。
*/
void Initialize() NN_NOEXCEPT;

/**
* @brief    es ライブラリ終了処理を行います。
*/
void Finalize() NN_NOEXCEPT;

}}  // namespace nn::es
