﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <movie/private/MultimediaTelemetryReport.h>

namespace nn { namespace err {

/**
* @brief        マルチメディアのエラーのレポートを作成します。
* @param[in]    result              エラーの内容を表す Result。
* @param[in]    mmTelemetryReport   エラー発生時のマルチメディアの情報。
* @details      マルチメディアライブラリがシムレイヤーでエラーを検出したときに内部で使用するための API です。
*               アプリから呼び出し可能ですが、ライブラリ内部での使用を想定しており、一般公開はしません。
*/
void ReportMultimediaError(nn::Result result, const movie::MultimediaTelemetryReport& mmTelemetryReport) NN_NOEXCEPT;

}}
