﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/erpt/erpt_Types.h>
#include <nn/erpt/common/erpt_Ids.h>

namespace nn   {
namespace erpt {
namespace srv  {

// To store reports on HOSTFS:
// 1. add <FlagPresets>Debug</FlagPresets> to <FsAccessControlDescriptor> in desc file
// 2. uncoment the following line
//#define USE_HOSTFS

#if defined(USE_HOSTFS)
const char ReportStoragePath[]  = "host";
const char JournalFileName[]    = "host:/journal";
#else
const char ReportStoragePath[]  = "save";
const char JournalFileName[]    = "save:/journal";
#endif

const int  ReportFileNameLength = 64;

#define GENERATE_CATEGORY(CATEGORY,ENUM,LOGDEPTH)           CATEGORY,
#define GENERATE_LOGDEPTH(CATEGORY,ENUM,LOGDEPTH)           LOGDEPTH,
#define GENERATE_CATEGORY_STRING(CATEGORY,...)              #CATEGORY,
#define GENERATE_FIELD_STRING(FIELD,...)                    #FIELD,
#define GENERATE_TYPE_STRING(TYPE,...)                      #TYPE,
#define GENERATE_FLAG_TYPE(ENUM,FLAG)                       ENUM = FLAG,

#if defined(NN_BUILD_CONFIG_OS_WIN)
#define ASSIGN_FIELD_CATEGORY(FIELD,ENUM,TYPE,CATEGORY,...) CATEGORY,
#define ASSIGN_FIELD_TYPE(FIELD,ENUM,TYPE,...)              TYPE,
#define ASSIGN_FIELD_FLAG(...)                              FieldFlag_None,
#else
#define ASSIGN_FIELD_CATEGORY(FIELD,ENUM,TYPE,CATEGORY,...) [ENUM] = CATEGORY,
#define ASSIGN_FIELD_TYPE(FIELD,ENUM,TYPE,...)              [ENUM] = TYPE,
#define FIELD_FLAG(FIELD,ENUM,TYPE,CATEGORY,FLAG)           [ENUM] = FLAG,
#define EMPTY_FLAG(FIELD,ENUM,...)                          [ENUM] = FieldFlag_None,
#define GET_FLAGS(FIELD,ENUM,TYPE,CATEGORY,FLAG,NAME,...)   NAME
#define ASSIGN_FIELD_FLAG(...)                              GET_FLAGS(__VA_ARGS__,FIELD_FLAG,EMPTY_FLAG)(__VA_ARGS__)
#endif


// max length of the string representing field id
const uint32_t MaxFieldStringSize = 64;

// field flags
enum FieldFlag : uint8_t
{
    FOREACH_FLAG(GENERATE_FLAG_TYPE)
};

// string for each field id
static const char* FieldString[] =
{
    FOREACH_ID(GENERATE_FIELD_STRING)
};

// string for each category id
static const char* CategoryString[] =
{
    FOREACH_CATEGORY(GENERATE_CATEGORY_STRING)
};

// string for each type
static const char* TypeString[] =
{
    FOREACH_TYPE(GENERATE_TYPE_STRING)
};

// number of context entries to keep in circular buffer per category
static const uint32_t CategoryLogDepth[] =
{
    FOREACH_CATEGORY(GENERATE_LOGDEPTH)
};

// field id to category map
static const CategoryId FieldToCategoryMap[] =
{
    FOREACH_ID(ASSIGN_FIELD_CATEGORY)
};

// field id to type map
static const FieldType FieldToTypeMap[] =
{
    FOREACH_ID(ASSIGN_FIELD_TYPE)
};

// field id to flag map
static const FieldFlag FieldToFlagMap[] =
{
    FOREACH_ID(ASSIGN_FIELD_FLAG)
};

#undef GENERATE_LOGDEPTH
#undef GENERATE_CATEGORY_STRING
#undef GENERATE_FIELD_STRING
#undef GENERATE_TYPE_STRING
#undef GENERATE_FLAG_TYPE
#undef ASSIGN_FIELD_CATEGORY
#undef ASSIGN_FIELD_TYPE
#undef ASSIGN_FIELD_FLAG
#undef FIELD_FLAG
#undef EMPTY_FLAG
#undef GET_FLAGS
#undef FOREACH_ID
#undef FOREACH_CATEGORY
#undef FOREACH_TYPE

struct ReportFileName
{
    char name[ReportFileNameLength];
};

NN_FORCEINLINE ReportFlagSet MakeNoReportFlags()
{
    return ::nn::util::MakeBitFlagSet<32, ReportFlag>();
}

inline bool operator==(const ReportId& lhs, const ReportId& rhs)
{
    return std::memcmp(&lhs.u.id, &rhs.u.id, sizeof(((ReportId*)0)->u.uuid)) ? false : true;
}

}}}

