﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn   {
namespace erpt {
namespace srv  {

nn::Result Initialize(uint8_t* pReportMemory, size_t reportMemorySize)
NN_NOEXCEPT;

nn::Result InitializeAndStartService()
NN_NOEXCEPT;

nn::Result SetSerialNumberAndOsVersion(
    const char* pSerialNumber, uint32_t serialNumberLength,
    const char* pOsVersion, uint32_t versionLength,
    const char* pPrivateOsVersion, uint32_t privateOsVersionLength)
NN_NOEXCEPT;

nn::Result SetProductModel(
    const char* pProductModel, uint32_t productModelLength
)
NN_NOEXCEPT;

nn::Result SetRegionSetting(
    const char* pRegion, uint32_t regionLength
)
NN_NOEXCEPT;

void Wait()
NN_NOEXCEPT;

}}}

