﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_Types.h>
#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/ec/system/ec_Async.h>
#include <nn/ec/system/ec_DeviceAccountTypes.h>
#include <nn/ec/system/ec_DeviceLinkTypes.h>

namespace nn { namespace ec { namespace system {
    /**
    * @brief    非推奨の関数です。もう一方の RequestUnlinkDevice を使ってください。
    *
    */
    NN_DEPRECATED Result RequestUnlinkDevice(AsyncResult* outValue, account::NintendoAccountId naUserId) NN_NOEXCEPT;

    /**
    * @brief    指定のユーザーアカウントのバーチャルアカウントの作成を要求します。
    *           この関数のみでは機器認証は行われません。
    *           機器認証登録を行うためにはこの関数の使用後に機器認証登録を要求する必要があります。
    *
    * @details  非同期処理をリクエストして、AsyncResult を返します。
    *           処理の結果は AsyncResult から取得してください。
    *           処理が成功するためには、インフラ通信が確立している必要があります。
    *           この関数で同時にリクエストできる非同期処理は最大１つです。
    *           他の非同期処理を実行するためには AsyncResult を破棄する必要があります。
    *           nn::ec::system 名前空間の Request～ 関数と最大非同期処理可能数を共有しています。
    *
    * @return   処理の結果が返ります。通信エラーなどは AsyncResult から下位レイヤの Result が返されます。必要があればエラーコードを表示してください。
    * @retval   ResultNintendoAccountNotLinked  指定されたアカウントにニンテンドーアカウントが紐付いていません。
    * @retval   ResultOutOfMaxTask              同時に発行できるリクエスト数が最大に達しています。
    * @retval   ResultCanceled                  （AsyncResult から返される Result）処理がキャンセルされました。
    */
    Result RequestCreateVirtualAccount(AsyncResult* outValue, const account::Uid& uid) NN_NOEXCEPT;

    /**
    * @brief    指定のユーザーアカウントで機器認証登録を要求します。
    *
    * @details  非同期処理をリクエストして、AsyncResult を返します。
    *           処理の結果は AsyncResult から取得してください。
    *           処理が成功するためには、インフラ通信が確立している必要があります。
    *           この関数で同時にリクエストできる非同期処理は最大１つです。
    *           他の非同期処理を実行するためには AsyncResult を破棄する必要があります。
    *           nn::ec::system 名前空間の Request～ 関数と最大非同期処理可能数を共有しています。
    *
    * @return   処理の結果が返ります。通信エラーなどは AsyncResult から下位レイヤの Result が返されます。必要があればエラーコードを表示してください。
    * @retval   ResultNintendoAccountNotLinked  指定されたアカウントにニンテンドーアカウントが紐付いていません。
    * @retval   ResultOutOfMaxTask              同時に発行できるリクエスト数が最大に達しています。
    * @retval   ResultAccountAlreadyDeviceLinked（AsyncResult から返される Result）ニンテンドーアカウントが他のデバイスで既に機器認証されています。
    * @retval   ResultCanceled                  （AsyncResult から返される Result）処理がキャンセルされました。
    */
    Result RequestLinkDevice(AsyncResult* outValue, const account::Uid& uid) NN_NOEXCEPT;

    /**
    * @brief    指定のユーザーアカウントで機器認証解除を要求します。
    *
    * @details  非同期処理をリクエストして、AsyncResult を返します。
    *           処理の結果は AsyncResult から取得してください。
    *           処理が成功するためには、インフラ通信が確立している必要があります。
    *           この関数で同時にリクエストできる非同期処理は最大１つです。
    *           他の非同期処理を実行するためには AsyncResult を破棄する必要があります。
    *           nn::ec::system 名前空間の Request～ 関数と最大非同期処理可能数を共有しています。
    *
    * @return   処理の結果が返ります。通信エラーなどは AsyncResult から下位レイヤの Result が返されます。必要があればエラーコードを表示してください。
    * @retval   ResultAccountNotDeviceLinked    この本体を機器認証しているアカウントではありません。
    * @retval   ResultOutOfMaxTask              同時に発行できるリクエスト数が最大に達しています。
    * @retval   ResultCanceled                  （AsyncResult から返される Result）処理がキャンセルされました。
    */
    Result RequestUnlinkDevice(AsyncResult* outValue, const account::Uid& uid) NN_NOEXCEPT;

    /**
    * @brief    デバイスに紐付く全ての機器認証解除を要求します。
    *
    * @details  非同期処理をリクエストして、AsyncResult を返します。
    *           処理の結果は AsyncResult から取得してください。
    *           処理が成功するためには、インフラ通信が確立している必要があります。
    *           この関数で同時にリクエストできる非同期処理は最大１つです。
    *           他の非同期処理を実行するためには AsyncResult を破棄する必要があります。
    *           nn::ec::system 名前空間の Request～ 関数と最大非同期処理可能数を共有しています。
    *
    * @return   処理の結果が返ります。通信エラーなどは AsyncResult から下位レイヤの Result が返されます。必要があればエラーコードを表示してください。
    * @retval   ResultOutOfMaxTask              同時に発行できるリクエスト数が最大に達しています。
    * @retval   ResultCanceled                  （AsyncResult から返される Result）処理がキャンセルされました。
    */
    Result RequestUnlinkDeviceAll(AsyncResult* outValue) NN_NOEXCEPT;

    /**
    * @brief    指定のユーザーアカウントの機器認証登録状態をサーバから取得します。
    *
    * @details  非同期処理をリクエストして、AsyncResult を返します。
    *           処理の結果は AsyncResult から取得してください。
    *           処理が成功するためには、インフラ通信が確立している必要があります。
    *           この関数で同時にリクエストできる非同期処理は最大１つです。
    *           他の非同期処理を実行するためには AsyncResult を破棄する必要があります。
    *           nn::ec::system 名前空間の Request～ 関数と最大非同期処理可能数を共有しています。
    *
    * @return   処理の結果が返ります。通信エラーなどは AsyncResult から下位レイヤの Result が返されます。必要があればエラーコードを表示してください。
    * @retval   ResultOutOfMaxTask              同時に発行できるリクエスト数が最大に達しています。
    * @retval   ResultCanceled                  （AsyncResult から返される Result）処理がキャンセルされました。
    */
    typedef AsyncValue<DeviceLinkStatus> AsyncDeviceLinkStatus;
    Result RequestDeviceLinkStatus(AsyncDeviceLinkStatus* outValue, const account::Uid& uid) NN_NOEXCEPT;

    /**
    * @brief    指定のユーザーアカウントのデバイスリンク情報がローカルに存在するかを判定します。
    */
    bool HasDeviceLink(const account::Uid& uid) NN_NOEXCEPT;
}}}
