﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ec/ec_ShopTypesForSystem.h>

namespace nn { namespace ec { namespace detail {

// ShopN/miniShopN の最初の処理を行うページのドメインより後ろの部分(先頭の「/」は指定しない)
static const char* PathShopBase = "";
// ShopN/miniShopN 用の CallbackUrl 指定値
static const char* ShopCallbackUrl = "eshop://";
// AppId の考えうる最大長(= 符号なし64ビット整数の16進数表記の最大値(FFFFFFFFFFFFFFFF)桁数 + NULL文字分)
static const size_t MaxAppIdLength = 17;
// NsUid の考えうる最大長(= 符号なし64ビット整数の最大値(18446744073709551615)桁数 + NULL文字分)
static const size_t MaxNsUidLength = 21;
// CouponId の考えうる最大長(= 符号なし64ビット整数の最大値(18446744073709551615)桁数 + NULL文字分)
static const size_t MaxCouponIdLength = 21;

}}}
