﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief ショップページを開くのに利用される型や定数、引数の宣言(内部開発者向け)
 */

#pragma once

namespace nn { namespace ec { namespace detail {

//--------------------------------------------------------------------------
/**
 * @brief ShimVersion です。
 */
const uint16_t EcShimVersion = 0;

//--------------------------------------------------------------------------
/**
 * @brief 背景種類
 */
enum ShopBackgroundKind
{
    ShopBackgroundKind_Normal,                  //!< 通常
    ShopBackgroundKind_ApplicationCapture,      //!< 呼び出しアプリ画像
    ShopBackgroundKind_ApplicationCaptureBlur,  //!< 呼び出しアプリ画像(ぼかし)
    ShopBackgroundKind_Max                      //!< 列挙子の総数です。
};

//--------------------------------------------------------------------------
/**
 * @brief 終了理由
 */
enum ShopExitReason
{
    ShopExitReason_EndButtonPressed = 0,                //!< 「おわる」ボタンが押された。
    ShopExitReason_BackButtonPressed = 1,               //!< 「戻る」ボタンが押された。
    ShopExitReason_ExitMessage = 2,                     //!< システムからの終了メッセージを受け取りました。
    ShopExitReason_CallbackUrlReached = 3,              //!< コールバック URL に到達した。
    ShopExitReason_LastWindowDeleted = 4,               //!< 最後のウインドウが削除された。
    ShopExitReason_LocalNetworkDisconnectionDenied = 5, //!< ローカル通信の切断確認が許可されなかった
    ShopExitReason_MediaPlayerClosed = 6,               //!< メディアプレイヤーが閉じられた。
    ShopExitReason_CausedByWebPage = 7,                 //!< ウェブページから終了要求があり終了された。
    ShopExitReason_UserSelectionCanceled = 8,           //!< ユーザー選択がキャンセル操作で閉じられた。
    ShopExitReason_NetworkConnectionFailed = 9,         //!< ネットワーク接続に失敗した。
    ShopExitReason_SystemUpdateRequired = 10,           //!< 本体更新が必要とされた。
    ShopExitReason_Unexpected = 20                      //!< 想定外の要因で終了した。
};

}}} // namespace nn::ec::detail
