﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief ショップの機能を提供する内部用API定義
 */

#pragma once

#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>
#include <nn/ec/detail/ec_ShopTypesInternal.h>
#include <nn/ec/detail/ec_ShowShopPageArg.h>
#include <new>

namespace nn { namespace ec { namespace detail {

typedef std::aligned_storage<sizeof(ShowShopPageArg), std::alignment_of<ShowShopPageArg>::value>::type ShowShopPageArgStorage;

/**
 * @brief ShowShopPageArg を排他制御して用いるラッパークラスです。
 */
class ShowShopPageArgWrapper
{
public:
    inline ShowShopPageArgWrapper(ShowShopPageArgStorage& storage, nn::os::MutexType& mutex) NN_NOEXCEPT
    {
        nn::os::LockMutex(&mutex);
        m_pMutex = &mutex;
        m_pArg = new (&storage) ShowShopPageArg("");
    }
    inline ~ShowShopPageArgWrapper() NN_NOEXCEPT
    {
        m_pArg->~ShowShopPageArg();
        nn::os::UnlockMutex(m_pMutex);
    }
    NN_IMPLICIT operator ShowShopPageArg& () NN_NOEXCEPT
    {
        return *m_pArg;
    }
private:
    ShowShopPageArg* m_pArg;
    nn::os::MutexType* m_pMutex;
};

extern ShowShopPageArgStorage g_ShopPageArgStorage;
extern nn::os::MutexType g_ShopPageArgMutex;

bool ShowShopPageWrapper(ShowShopPageArg& arg, const nn::account::Uid& uid) NN_NOEXCEPT;
ShopPageReturnValue& GetShopPageReturnValue() NN_NOEXCEPT;

void LaunchEShopImpl(LaunchMode launchMode, const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
void ShowShopApplicationInformationImpl(LaunchMode launchMode, nn::ApplicationId applicationId,
    const nn::account::Uid& uid, SourceId sourceId, const char* newsId) NN_NOEXCEPT;
void ShowShopApplicationInformationImpl(LaunchMode launchMode, NsUid nsuidApplication,
    const nn::account::Uid& uid, SourceId sourceId, const char* newsId) NN_NOEXCEPT;
void ShowShopAddOnContentListImpl(LaunchMode launchMode, nn::ApplicationId applicationIdParent,
    const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
void ShowShopAddOnContentDetailsImpl(LaunchMode launchMode, NsUid nsuidAddOnContentItem,
    const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
void ShowShopSubscriptionListImpl(LaunchMode launchMode, nn::ApplicationId applicationIdParent,
    const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
void ShowShopSubscriptionListDetailImpl(LaunchMode launchMode, nn::ApplicationId applicationIdParent, const CourseId& courseId,
    const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
void ShowShopConsumableItemListImpl(LaunchMode launchMode, nn::ApplicationId applicationIdParent,
    const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
void ShowShopConsumableItemDetailImpl(LaunchMode launchMode, nn::ApplicationId applicationIdParent, const ConsumableId& consumableId, NsUid nsuidConsumableItem,
    const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
void ShowShopCouponImpl(LaunchMode launchMode, CouponId couponId,
    const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
void ShowShopInformationWithParamsImpl(LaunchMode launchMode, const char* params,
    const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
void ShowShopSecretApplicationInformationImpl(LaunchMode launchMode, nn::ApplicationId applicationId,
    const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
void ShowShopSecretApplicationInformationImpl(LaunchMode launchMode, NsUid nsuidApplication,
    const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
void ShowShopSettingsImpl(LaunchMode launchMode, const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
nn::Result ShowShopMembershipServiceInformationImpl(const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;
nn::Result GetShopResultFromStorageImpl(const nn::applet::StorageHandle& handle) NN_NOEXCEPT;
void ShowShopPreinstallInformationImpl(LaunchMode launchMode, const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT;

}}}
