﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Mutex.h>

namespace nn {
namespace codec {
namespace detail {

/**
 * @brief       nn::codec でサポートしている opus のビットレート最小値です。
 */
const int BitRateMin = 6000;

/**
 * @brief       nn::codec でサポートしている opus のモノラル設定向けビットレート最大値です。
 */
const int BitRateMaxForMonoral = 300000;

/**
 * @brief       nn::codec でサポートしている opus のステレオ設定向けビットレート最大値です。
 */
const int BitRateMaxForStereo = 510000;

/**
 * @brief       nn::codec の Opus で使用する空チャンネルを表す値です。
 */
const uint8_t OpusEmptyChannel = 255u;

/**
 * @brief       Opus のグローバル Mutex を取得します。
 * @return      nn::os::Mutex オブジェクトへの参照
 */
nn::os::Mutex& GetOpusGlobalMutex()  NN_NOEXCEPT;

}}}  // nn::codec::detail
