﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief ライブラリの初期化・終了機能の API 宣言。
 */

#pragma once

namespace nn { namespace bpc {

//! @name ライブラリの初期化・終了
//! @{

/**
 * @brief BPC ライブラリを初期化します。
 *
 * @deprecated
 *  ライブラリ初期化関数は機能ブロックごとに分割されましたので、そちらの利用に切り替えてください。
 *
 * @details
 *  本関数は一時的なビルド互換性のために残しています。@n
 *  本関数は、内部で nn::bpc::InitializeBoardPowerControl() と nn::bpc::InitializePowerButton() を呼び出します。
 */
NN_DEPRECATED void Initialize() NN_NOEXCEPT;

/**
 * @brief BPC ライブラリを終了します。
 *
 * @deprecated
 *  ライブラリ終了関数は機能ブロックごとに分割されましたので、そちらの利用に切り替えてください。
 *
 * @details
 *  本関数は一時的なビルド互換性のために残しています。@n
 *  本関数は、内部で nn::bpc::FinalizeBoardPowerControl() と nn::bpc::FinalizePowerButton() を呼び出します。
 */
NN_DEPRECATED void Finalize() NN_NOEXCEPT;

//! @}

}} // namepsace nn::bpc
