﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/bpc/bpc_BoardPowerControlTypes.h>
#include <nn/bpc/bpc_PowerButtonTypes.h>
#include <nn/bpc/bpc_WakeupConfigTypes.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace bpc { // NOLINT(whitespace/braces)

class IBoardPowerControlManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBoardPowerControlManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBoardPowerControlManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ShutdownSystem)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RebootSystem)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetWakeupReason, (::nn::sf::Out<::std::uint32_t> pOutWakeupReason))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetShutdownReason, (::nn::sf::Out<::std::uint32_t> pOutShutdownReason))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAcOk, (::nn::sf::Out<bool> pOutAcOk))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPowerEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle, ::nn::bpc::BoardPowerControlEventTarget target))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSleepButtonState, (::nn::sf::Out<::nn::bpc::SleepButtonState> pOutState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPowerButtonEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle, ::nn::bpc::EventTarget target))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateWakeupTimer, (::nn::sf::Out<::std::int32_t> outTimerId, ::nn::TimeSpanType interval))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelWakeupTimer, (::std::int32_t timerId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnableWakeupTimerOnDevice, (::nn::sf::Out<bool> outIsEnabled, ::nn::sf::Out<::std::int32_t> outTimerId, ::nn::sf::Out<::nn::bpc::WakeupTimerType> outType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateWakeupTimerEx, (::nn::sf::Out<::std::int32_t> outTimerId, ::nn::TimeSpanType interval, ::nn::bpc::WakeupTimerType type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLastEnabledWakeupTimerType, (::nn::sf::Out<::nn::bpc::WakeupTimerType> outType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CleanAllWakeupTimers, (::nn::bpc::WakeupTimerType type))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBoardPowerControlManager)

        ::nn::Result ShutdownSystem() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ShutdownSystem);
        }

        ::nn::Result RebootSystem() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RebootSystem);
        }

        ::nn::Result GetWakeupReason(::nn::sf::Out<::std::uint32_t> pOutWakeupReason) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetWakeupReason, (pOutWakeupReason));
        }

        ::nn::Result GetShutdownReason(::nn::sf::Out<::std::uint32_t> pOutShutdownReason) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetShutdownReason, (pOutShutdownReason));
        }

        ::nn::Result GetAcOk(::nn::sf::Out<bool> pOutAcOk) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAcOk, (pOutAcOk));
        }

        ::nn::Result GetPowerEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle, ::nn::bpc::BoardPowerControlEventTarget target) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPowerEvent, (pOutHandle, target));
        }

        ::nn::Result GetSleepButtonState(::nn::sf::Out<::nn::bpc::SleepButtonState> pOutState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSleepButtonState, (pOutState));
        }

        ::nn::Result GetPowerButtonEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle, ::nn::bpc::EventTarget target) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPowerButtonEvent, (pOutHandle, target));
        }

        ::nn::Result CreateWakeupTimer(::nn::sf::Out<::std::int32_t> outTimerId, ::nn::TimeSpanType interval) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateWakeupTimer, (outTimerId, interval));
        }

        ::nn::Result CancelWakeupTimer(::std::int32_t timerId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelWakeupTimer, (timerId));
        }

        ::nn::Result EnableWakeupTimerOnDevice(::nn::sf::Out<bool> outIsEnabled, ::nn::sf::Out<::std::int32_t> outTimerId, ::nn::sf::Out<::nn::bpc::WakeupTimerType> outType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnableWakeupTimerOnDevice, (outIsEnabled, outTimerId, outType));
        }

        ::nn::Result CreateWakeupTimerEx(::nn::sf::Out<::std::int32_t> outTimerId, ::nn::TimeSpanType interval, ::nn::bpc::WakeupTimerType type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateWakeupTimerEx, (outTimerId, interval, type));
        }

        ::nn::Result GetLastEnabledWakeupTimerType(::nn::sf::Out<::nn::bpc::WakeupTimerType> outType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLastEnabledWakeupTimerType, (outType));
        }

        ::nn::Result CleanAllWakeupTimers(::nn::bpc::WakeupTimerType type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CleanAllWakeupTimers, (type));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBoardPowerControlManager
    {
    public:
        nn::Result ShutdownSystem() NN_NOEXCEPT;
        nn::Result RebootSystem() NN_NOEXCEPT;
        nn::Result GetWakeupReason(nn::sf::Out<std::uint32_t> pOutWakeupReason) NN_NOEXCEPT;
        nn::Result GetShutdownReason(nn::sf::Out<std::uint32_t> pOutShutdownReason) NN_NOEXCEPT;
        nn::Result GetAcOk(nn::sf::Out<bool> pOutAcOk) NN_NOEXCEPT;
        nn::Result GetPowerEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::bpc::BoardPowerControlEventTarget target) NN_NOEXCEPT;
        nn::Result GetSleepButtonState(nn::sf::Out<nn::bpc::SleepButtonState> pOutState) NN_NOEXCEPT;
        nn::Result GetPowerButtonEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::bpc::EventTarget target) NN_NOEXCEPT;
        nn::Result CreateWakeupTimer(nn::sf::Out<std::int32_t> outTimerId, nn::TimeSpanType interval) NN_NOEXCEPT;
        nn::Result CancelWakeupTimer(std::int32_t timerId) NN_NOEXCEPT;
        nn::Result EnableWakeupTimerOnDevice(nn::sf::Out<bool> outIsEnabled, nn::sf::Out<std::int32_t> outTimerId, nn::sf::Out<nn::bpc::WakeupTimerType> outType) NN_NOEXCEPT;
        nn::Result CreateWakeupTimerEx(nn::sf::Out<std::int32_t> outTimerId, nn::TimeSpanType interval, nn::bpc::WakeupTimerType type) NN_NOEXCEPT;
        nn::Result GetLastEnabledWakeupTimerType(nn::sf::Out<nn::bpc::WakeupTimerType> outType) NN_NOEXCEPT;
        nn::Result CleanAllWakeupTimers(nn::bpc::WakeupTimerType type) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result ShutdownSystem() NN_NOEXCEPT;
    nn::Result RebootSystem() NN_NOEXCEPT;
    nn::Result GetWakeupReason(nn::sf::Out<std::uint32_t> pOutWakeupReason) NN_NOEXCEPT;
    nn::Result GetShutdownReason(nn::sf::Out<std::uint32_t> pOutShutdownReason) NN_NOEXCEPT;
    nn::Result GetAcOk(nn::sf::Out<bool> pOutAcOk) NN_NOEXCEPT;
    nn::Result GetPowerEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::bpc::BoardPowerControlEventTarget target) NN_NOEXCEPT;
    nn::Result GetSleepButtonState(nn::sf::Out<nn::bpc::SleepButtonState> pOutState) NN_NOEXCEPT;
    nn::Result GetPowerButtonEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::bpc::EventTarget target) NN_NOEXCEPT;
    nn::Result CreateWakeupTimer(nn::sf::Out<std::int32_t> outTimerId, nn::TimeSpanType interval) NN_NOEXCEPT;
    nn::Result CancelWakeupTimer(std::int32_t timerId) NN_NOEXCEPT;
    nn::Result EnableWakeupTimerOnDevice(nn::sf::Out<bool> outIsEnabled, nn::sf::Out<std::int32_t> outTimerId, nn::sf::Out<nn::bpc::WakeupTimerType> outType) NN_NOEXCEPT;
    nn::Result CreateWakeupTimerEx(nn::sf::Out<std::int32_t> outTimerId, nn::TimeSpanType interval, nn::bpc::WakeupTimerType type) NN_NOEXCEPT;
    nn::Result GetLastEnabledWakeupTimerType(nn::sf::Out<nn::bpc::WakeupTimerType> outType) NN_NOEXCEPT;
    nn::Result CleanAllWakeupTimers(nn::bpc::WakeupTimerType type) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::bpc::IBoardPowerControlManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ShutdownSystem)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ShutdownSystem);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RebootSystem)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RebootSystem);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetWakeupReason, (::nn::sf::Out<::std::uint32_t> pOutWakeupReason))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetWakeupReason, (pOutWakeupReason));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetShutdownReason, (::nn::sf::Out<::std::uint32_t> pOutShutdownReason))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetShutdownReason, (pOutShutdownReason));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAcOk, (::nn::sf::Out<bool> pOutAcOk))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAcOk, (pOutAcOk));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPowerEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle, ::nn::bpc::BoardPowerControlEventTarget target))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPowerEvent, (pOutHandle, target));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSleepButtonState, (::nn::sf::Out<::nn::bpc::SleepButtonState> pOutState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSleepButtonState, (pOutState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPowerButtonEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle, ::nn::bpc::EventTarget target))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPowerButtonEvent, (pOutHandle, target));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateWakeupTimer, (::nn::sf::Out<::std::int32_t> outTimerId, ::nn::TimeSpanType interval))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateWakeupTimer, (outTimerId, interval));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelWakeupTimer, (::std::int32_t timerId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelWakeupTimer, (timerId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableWakeupTimerOnDevice, (::nn::sf::Out<bool> outIsEnabled, ::nn::sf::Out<::std::int32_t> outTimerId, ::nn::sf::Out<::nn::bpc::WakeupTimerType> outType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnableWakeupTimerOnDevice, (outIsEnabled, outTimerId, outType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateWakeupTimerEx, (::nn::sf::Out<::std::int32_t> outTimerId, ::nn::TimeSpanType interval, ::nn::bpc::WakeupTimerType type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateWakeupTimerEx, (outTimerId, interval, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLastEnabledWakeupTimerType, (::nn::sf::Out<::nn::bpc::WakeupTimerType> outType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLastEnabledWakeupTimerType, (outType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CleanAllWakeupTimers, (::nn::bpc::WakeupTimerType type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CleanAllWakeupTimers, (type));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::bpc::IBoardPowerControlManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::bpc::IBoardPowerControlManager))

    // nn::Result ShutdownSystem() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ShutdownSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ShutdownSystem)

    // nn::Result RebootSystem() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RebootSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RebootSystem)

    // nn::Result GetWakeupReason(nn::sf::Out<std::uint32_t> pOutWakeupReason) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetWakeupReason)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutWakeupReason, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutWakeupReason))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutWakeupReason)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetWakeupReason)

    // nn::Result GetShutdownReason(nn::sf::Out<std::uint32_t> pOutShutdownReason) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetShutdownReason)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutShutdownReason, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutShutdownReason))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutShutdownReason)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetShutdownReason)

    // nn::Result GetAcOk(nn::sf::Out<bool> pOutAcOk) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAcOk)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutAcOk, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutAcOk))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAcOk)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAcOk)

    // nn::Result GetPowerEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::bpc::BoardPowerControlEventTarget target) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPowerEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::nn::bpc::BoardPowerControlEventTarget), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPowerEvent)

    // nn::Result GetSleepButtonState(nn::sf::Out<nn::bpc::SleepButtonState> pOutState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSleepButtonState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutState, (::nn::bpc::SleepButtonState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSleepButtonState)

    // nn::Result GetPowerButtonEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::bpc::EventTarget target) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPowerButtonEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::nn::bpc::EventTarget), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPowerButtonEvent)

    // nn::Result CreateWakeupTimer(nn::sf::Out<std::int32_t> outTimerId, nn::TimeSpanType interval) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateWakeupTimer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(interval, (::nn::TimeSpanType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (interval))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outTimerId, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outTimerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTimerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(interval)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateWakeupTimer)

    // nn::Result CancelWakeupTimer(std::int32_t timerId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelWakeupTimer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(timerId, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (timerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(timerId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelWakeupTimer)

    // nn::Result EnableWakeupTimerOnDevice(nn::sf::Out<bool> outIsEnabled, nn::sf::Out<std::int32_t> outTimerId, nn::sf::Out<nn::bpc::WakeupTimerType> outType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableWakeupTimerOnDevice)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsEnabled, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outTimerId, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outType, (::nn::bpc::WakeupTimerType), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (outIsEnabled, outTimerId, outType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsEnabled), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTimerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableWakeupTimerOnDevice)

    // nn::Result CreateWakeupTimerEx(nn::sf::Out<std::int32_t> outTimerId, nn::TimeSpanType interval, nn::bpc::WakeupTimerType type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateWakeupTimerEx)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::nn::bpc::WakeupTimerType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(interval, (::nn::TimeSpanType), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, interval))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outTimerId, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outTimerId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTimerId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(interval), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateWakeupTimerEx)

    // nn::Result GetLastEnabledWakeupTimerType(nn::sf::Out<nn::bpc::WakeupTimerType> outType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLastEnabledWakeupTimerType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outType, (::nn::bpc::WakeupTimerType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLastEnabledWakeupTimerType)

    // nn::Result CleanAllWakeupTimers(nn::bpc::WakeupTimerType type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CleanAllWakeupTimers)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::nn::bpc::WakeupTimerType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (type))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CleanAllWakeupTimers)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bpc::BoardPowerControlEventTarget), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bpc::SleepButtonState), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bpc::EventTarget), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::TimeSpanType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bpc::WakeupTimerType), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::bpc::IBoardPowerControlManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::bpc::IBoardPowerControlManager))

    // nn::Result ShutdownSystem() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ShutdownSystem)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ShutdownSystem)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ShutdownSystem)
    }

    // nn::Result RebootSystem() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RebootSystem)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RebootSystem)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RebootSystem)
    }

    // nn::Result GetWakeupReason(nn::sf::Out<std::uint32_t> pOutWakeupReason) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetWakeupReason, (::nn::sf::Out<::std::uint32_t> pOutWakeupReason))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetWakeupReason)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutWakeupReason)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetWakeupReason)
    }

    // nn::Result GetShutdownReason(nn::sf::Out<std::uint32_t> pOutShutdownReason) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetShutdownReason, (::nn::sf::Out<::std::uint32_t> pOutShutdownReason))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetShutdownReason)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutShutdownReason)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetShutdownReason)
    }

    // nn::Result GetAcOk(nn::sf::Out<bool> pOutAcOk) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAcOk, (::nn::sf::Out<bool> pOutAcOk))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAcOk)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAcOk)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAcOk)
    }

    // nn::Result GetPowerEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::bpc::BoardPowerControlEventTarget target) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPowerEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle, ::nn::bpc::BoardPowerControlEventTarget target))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPowerEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPowerEvent)
    }

    // nn::Result GetSleepButtonState(nn::sf::Out<nn::bpc::SleepButtonState> pOutState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSleepButtonState, (::nn::sf::Out<::nn::bpc::SleepButtonState> pOutState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSleepButtonState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSleepButtonState)
    }

    // nn::Result GetPowerButtonEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::bpc::EventTarget target) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPowerButtonEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle, ::nn::bpc::EventTarget target))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPowerButtonEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPowerButtonEvent)
    }

    // nn::Result CreateWakeupTimer(nn::sf::Out<std::int32_t> outTimerId, nn::TimeSpanType interval) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateWakeupTimer, (::nn::sf::Out<::std::int32_t> outTimerId, ::nn::TimeSpanType interval))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateWakeupTimer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTimerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(interval)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateWakeupTimer)
    }

    // nn::Result CancelWakeupTimer(std::int32_t timerId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelWakeupTimer, (::std::int32_t timerId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelWakeupTimer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(timerId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelWakeupTimer)
    }

    // nn::Result EnableWakeupTimerOnDevice(nn::sf::Out<bool> outIsEnabled, nn::sf::Out<std::int32_t> outTimerId, nn::sf::Out<nn::bpc::WakeupTimerType> outType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableWakeupTimerOnDevice, (::nn::sf::Out<bool> outIsEnabled, ::nn::sf::Out<::std::int32_t> outTimerId, ::nn::sf::Out<::nn::bpc::WakeupTimerType> outType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableWakeupTimerOnDevice)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTimerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableWakeupTimerOnDevice)
    }

    // nn::Result CreateWakeupTimerEx(nn::sf::Out<std::int32_t> outTimerId, nn::TimeSpanType interval, nn::bpc::WakeupTimerType type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateWakeupTimerEx, (::nn::sf::Out<::std::int32_t> outTimerId, ::nn::TimeSpanType interval, ::nn::bpc::WakeupTimerType type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateWakeupTimerEx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTimerId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(interval)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateWakeupTimerEx)
    }

    // nn::Result GetLastEnabledWakeupTimerType(nn::sf::Out<nn::bpc::WakeupTimerType> outType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLastEnabledWakeupTimerType, (::nn::sf::Out<::nn::bpc::WakeupTimerType> outType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLastEnabledWakeupTimerType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLastEnabledWakeupTimerType)
    }

    // nn::Result CleanAllWakeupTimers(nn::bpc::WakeupTimerType type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CleanAllWakeupTimers, (::nn::bpc::WakeupTimerType type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CleanAllWakeupTimers)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CleanAllWakeupTimers)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::bpc::IBoardPowerControlManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::bpc::IBoardPowerControlManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ShutdownSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ShutdownSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RebootSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RebootSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetWakeupReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetWakeupReason)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutWakeupReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetShutdownReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetShutdownReason)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutShutdownReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAcOk)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAcOk)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutAcOk)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPowerEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPowerEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSleepButtonState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSleepButtonState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPowerButtonEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPowerButtonEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateWakeupTimer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateWakeupTimer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outTimerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(interval)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelWakeupTimer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelWakeupTimer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(timerId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableWakeupTimerOnDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableWakeupTimerOnDevice)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsEnabled),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outTimerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateWakeupTimerEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateWakeupTimerEx)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outTimerId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(interval),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLastEnabledWakeupTimerType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLastEnabledWakeupTimerType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CleanAllWakeupTimers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CleanAllWakeupTimers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ShutdownSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RebootSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetWakeupReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetShutdownReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAcOk)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPowerEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSleepButtonState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPowerButtonEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateWakeupTimer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelWakeupTimer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableWakeupTimerOnDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateWakeupTimerEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLastEnabledWakeupTimerType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CleanAllWakeupTimers)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::bpc::IBoardPowerControlManager))
