﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace bgtc { // NOLINT(whitespace/braces)

class IStateControlService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IStateControlService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IStateControlService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::int32_t> outState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStateChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(NotifyEnteringHalfAwake)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(NotifyLeavingHalfAwake)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetIsUsingSleepUnsupportedDevices, (bool bIsUsing))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IStateControlService)

        ::nn::Result GetState(::nn::sf::Out<::std::int32_t> outState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetState, (outState));
        }

        ::nn::Result GetStateChangedEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStateChangedEvent, (outHandle));
        }

        ::nn::Result NotifyEnteringHalfAwake() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(NotifyEnteringHalfAwake);
        }

        ::nn::Result NotifyLeavingHalfAwake() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(NotifyLeavingHalfAwake);
        }

        ::nn::Result SetIsUsingSleepUnsupportedDevices(bool bIsUsing) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetIsUsingSleepUnsupportedDevices, (bIsUsing));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IStateControlService
    {
    public:
        nn::Result GetState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT;
        nn::Result GetStateChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
        nn::Result NotifyEnteringHalfAwake() NN_NOEXCEPT;
        nn::Result NotifyLeavingHalfAwake() NN_NOEXCEPT;
        nn::Result SetIsUsingSleepUnsupportedDevices(bool bIsUsing) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT;
    nn::Result GetStateChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result NotifyEnteringHalfAwake() NN_NOEXCEPT;
    nn::Result NotifyLeavingHalfAwake() NN_NOEXCEPT;
    nn::Result SetIsUsingSleepUnsupportedDevices(bool bIsUsing) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::bgtc::IStateControlService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::int32_t> outState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetState, (outState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStateChangedEvent, (outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyEnteringHalfAwake)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(NotifyEnteringHalfAwake);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyLeavingHalfAwake)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(NotifyLeavingHalfAwake);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetIsUsingSleepUnsupportedDevices, (bool bIsUsing))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetIsUsingSleepUnsupportedDevices, (bIsUsing));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::bgtc::IStateControlService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::bgtc::IStateControlService))

    // nn::Result GetState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outState, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetState)

    // nn::Result GetStateChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStateChangedEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStateChangedEvent)

    // nn::Result NotifyEnteringHalfAwake() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyEnteringHalfAwake)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyEnteringHalfAwake)

    // nn::Result NotifyLeavingHalfAwake() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyLeavingHalfAwake)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyLeavingHalfAwake)

    // nn::Result SetIsUsingSleepUnsupportedDevices(bool bIsUsing) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetIsUsingSleepUnsupportedDevices)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bIsUsing, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bIsUsing))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bIsUsing)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetIsUsingSleepUnsupportedDevices)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::bgtc::IStateControlService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::bgtc::IStateControlService))

    // nn::Result GetState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::int32_t> outState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetState)
    }

    // nn::Result GetStateChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStateChangedEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStateChangedEvent)
    }

    // nn::Result NotifyEnteringHalfAwake() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyEnteringHalfAwake)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyEnteringHalfAwake)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyEnteringHalfAwake)
    }

    // nn::Result NotifyLeavingHalfAwake() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyLeavingHalfAwake)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyLeavingHalfAwake)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyLeavingHalfAwake)
    }

    // nn::Result SetIsUsingSleepUnsupportedDevices(bool bIsUsing) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetIsUsingSleepUnsupportedDevices, (bool bIsUsing))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetIsUsingSleepUnsupportedDevices)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bIsUsing)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetIsUsingSleepUnsupportedDevices)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::bgtc::IStateControlService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::bgtc::IStateControlService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStateChangedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStateChangedEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyEnteringHalfAwake)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyEnteringHalfAwake)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyLeavingHalfAwake)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyLeavingHalfAwake)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetIsUsingSleepUnsupportedDevices)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetIsUsingSleepUnsupportedDevices)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bIsUsing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStateChangedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyEnteringHalfAwake)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyLeavingHalfAwake)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetIsUsingSleepUnsupportedDevices)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::bgtc::IStateControlService))
