﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/psc.h>
#include <nn/os.h>

namespace nn{ namespace bgsu{

class PowerStateEventHandler
{
public:
    psc::PmState GetLastPowerState() const
    {
        return m_LastPmState;
    }

protected:
    PowerStateEventHandler();
    virtual ~PowerStateEventHandler();

    Result Initialize(psc::PmModuleId moduleId, const psc::PmModuleId* pDependencyList, uint32_t dependencyCount);
    virtual void Finalize();

    void Dispatch();
    os::SystemEvent& GetEvent();
    virtual void OnReceivePowerStateEvent(psc::PmState stateLast, psc::PmState stateTo, psc::PmFlagSet flagset) = 0;

    bool IsTrrigeredFromFullAwake() const
    {
        return m_bFromFullAwake;
    }

private:
    psc::PmModule m_PmModule;
    psc::PmState  m_LastPmState;
    os::SystemEvent* m_pEvent;
    bool m_bFromFullAwake;
};

}}
