﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/sdmmc/sdmmc_Common.h>

namespace nn { namespace bconfig {

/**
 * @brief BootConfig の非署名領域の情報を保持する構造体です
 */
struct BootConfig
{
    //!< バージョン番号
    Bit64 version;

    // 未使用領域
    Bit8  unused00[4];
    Bit8  unused01[4];

    // デフォルト 1 の予約領域
    Bit8  reservedDefault1[16];

    // デフォルト 0 の予約領域
    Bit8  reservedDefault0[16];

    // TSC (Tick) の初期値
    Bit8  tscInitialValue[8];

    // 未使用領域
    Bit8  unused38[sdmmc::SectorSize - 0x38];
};

}} // namespace nn::bconfig
