﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace core {

/*!
    @brief      BCAT アーカイブデータの署名検証公開を管理するモジュールです。

    @details
                本モジュールは、開発機と製品機で異なるデータを返す場合があります。
*/
class PublicKey
{
public:
    /*!
        @brief      法データを取得します。

        @return     法データ。
    */
    static const Bit8* GetModulus() NN_NOEXCEPT;

    /*!
        @brief      法データのサイズを取得します。

        @return     法データのサイズ。
    */
    static size_t GetModulusSize() NN_NOEXCEPT;

    /*!
        @brief      公開指数データを取得します。

        @return     公開指数データ。
    */
    static const Bit8* GetPublicExponent() NN_NOEXCEPT;

    /*!
        @brief      公開指数データのサイズを取得します。

        @return     公開指数データのサイズ。
    */
    static size_t GetPublicExponentSize() NN_NOEXCEPT;
};

}}}}}
