﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace bcat { namespace detail { namespace service {

/*!
    @brief      ケイパビリティです。

    @details
                API の権限管理を行うために利用します。
*/
class Capability
{
public:
    /*!
        @brief      ケイパビリティフラグです。
    */
    enum Flag : Bit32
    {
        Flag_Generic    = 0x00000001, //!< 一般権限。
        Flag_System     = 0x00000002, //!< システム権限。
        Flag_Management = 0x00000004, //!< 管理特権。
        Flag_Debug      = 0x00000008, //!< デバッグ特権。
        Flag_All        = 0xFFFFFFFF  //!< 全権。
    };

public:
    /*!
        @brief      コンストラクタです。

        @param[in]  flags   ケイパビリティフラグ。
    */
    NN_IMPLICIT Capability(Bit32 flags) NN_NOEXCEPT
    {
        m_Flags = flags;
    }

    /*!
        @brief      許可されているかどうかを確認します。

        @param[in]  flags   ケイパビリティフラグ。

        @return     許可されているかどうか。

        @details
                    複数のケイパビリティフラグを指定した場合、いずれかのフラグが立っていれば true を返します。
    */
    bool IsPermitted(Bit32 flags) const NN_NOEXCEPT
    {
        return (m_Flags & flags) != 0;
    }

private:
    //
    Bit32 m_Flags;
};

}}}}
