﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      audio モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_AUDIO_TRACE(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(audio, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_TRACE_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audio, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_TRACE_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audio, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_TRACE_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audio, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_AUDIO_INFO(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(audio, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_INFO_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(audio, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_INFO_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(audio, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_INFO_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(audio, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_AUDIO_WARN(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(audio, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_WARN_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(audio, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_WARN_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(audio, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_WARN_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(audio, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_AUDIO_ERROR(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(audio, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_ERROR_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audio, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_ERROR_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audio, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_ERROR_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audio, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_AUDIO_FATAL(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(audio, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_FATAL_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audio, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_FATAL_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audio, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_AUDIO_FATAL_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(audio, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_AUDIO_VTRACE(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Trace, 0, format, args)
#define NN_DETAIL_AUDIO_VTRACE_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Trace, 1, format, args)
#define NN_DETAIL_AUDIO_VTRACE_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Trace, 2, format, args)
#define NN_DETAIL_AUDIO_VTRACE_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Trace, 3, format, args)

#define NN_DETAIL_AUDIO_VINFO(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Info, 0, format, args)
#define NN_DETAIL_AUDIO_VINFO_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Info, 1, format, args)
#define NN_DETAIL_AUDIO_VINFO_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Info, 2, format, args)
#define NN_DETAIL_AUDIO_VINFO_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Info, 3, format, args)

#define NN_DETAIL_AUDIO_VWARN(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Warn, 0, format, args)
#define NN_DETAIL_AUDIO_VWARN_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Warn, 1, format, args)
#define NN_DETAIL_AUDIO_VWARN_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Warn, 2, format, args)
#define NN_DETAIL_AUDIO_VWARN_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Warn, 3, format, args)

#define NN_DETAIL_AUDIO_VERROR(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Error, 0, format, args)
#define NN_DETAIL_AUDIO_VERROR_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Error, 1, format, args)
#define NN_DETAIL_AUDIO_VERROR_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Error, 2, format, args)
#define NN_DETAIL_AUDIO_VERROR_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Error, 3, format, args)

#define NN_DETAIL_AUDIO_VFATAL(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Fatal, 0, format, args)
#define NN_DETAIL_AUDIO_VFATAL_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Fatal, 1, format, args)
#define NN_DETAIL_AUDIO_VFATAL_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Fatal, 2, format, args)
#define NN_DETAIL_AUDIO_VFATAL_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(audio, Fatal, 3, format, args)

#define NN_DETAIL_AUDIO_PUT_TRACE(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(audio, Trace, 0, text, length)
#define NN_DETAIL_AUDIO_PUT_TRACE_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audio, Trace, 1, text, length)
#define NN_DETAIL_AUDIO_PUT_TRACE_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audio, Trace, 2, text, length)
#define NN_DETAIL_AUDIO_PUT_TRACE_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audio, Trace, 3, text, length)

#define NN_DETAIL_AUDIO_PUT_INFO(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(audio, Info, 0, text, length)
#define NN_DETAIL_AUDIO_PUT_INFO_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(audio, Info, 1, text, length)
#define NN_DETAIL_AUDIO_PUT_INFO_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(audio, Info, 2, text, length)
#define NN_DETAIL_AUDIO_PUT_INFO_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(audio, Info, 3, text, length)

#define NN_DETAIL_AUDIO_PUT_WARN(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(audio, Warn, 0, text, length)
#define NN_DETAIL_AUDIO_PUT_WARN_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(audio, Warn, 1, text, length)
#define NN_DETAIL_AUDIO_PUT_WARN_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(audio, Warn, 2, text, length)
#define NN_DETAIL_AUDIO_PUT_WARN_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(audio, Warn, 3, text, length)

#define NN_DETAIL_AUDIO_PUT_ERROR(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(audio, Error, 0, text, length)
#define NN_DETAIL_AUDIO_PUT_ERROR_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audio, Error, 1, text, length)
#define NN_DETAIL_AUDIO_PUT_ERROR_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audio, Error, 2, text, length)
#define NN_DETAIL_AUDIO_PUT_ERROR_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audio, Error, 3, text, length)

#define NN_DETAIL_AUDIO_PUT_FATAL(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(audio, Fatal, 0, text, length)
#define NN_DETAIL_AUDIO_PUT_FATAL_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audio, Fatal, 1, text, length)
#define NN_DETAIL_AUDIO_PUT_FATAL_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audio, Fatal, 2, text, length)
#define NN_DETAIL_AUDIO_PUT_FATAL_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(audio, Fatal, 3, text, length)
