﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace audio { namespace detail { // NOLINT(whitespace/braces)

class IFinalOutputRecorder;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFinalOutputRecorder, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFinalOutputRecorder)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFinalOutputRecorderState, (::nn::sf::Out<::std::uint32_t> outFinalOutputRecorder))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Start)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Stop)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AppendFinalOutputRecorderBuffer, (const ::nn::sf::InBuffer& outFinalOutputRecorderBuffer, ::std::uint64_t outBufferClientPtr))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBufferEvent, (::nn::sf::Out<::nn::sf::NativeHandle> bufferEvent))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReleasedFinalOutputRecorderBuffers, (const ::nn::sf::OutBuffer& outFinalOutputRecorderBuffer, ::nn::sf::Out<::std::int32_t> count, ::nn::sf::Out<::std::int64_t> released))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ContainsFinalOutputRecorderBuffer, (::std::uint64_t FinalOutputRecorderBufferPointer, ::nn::sf::Out<bool> contains))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFinalOutputRecorderBufferEndTime, (::std::uint64_t FinalOutputRecorderBufferPointer, ::nn::sf::Out<::std::int64_t> released))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AppendFinalOutputRecorderBufferAuto, (const ::nn::sf::InBuffer& outFinalOutputRecorderBuffer, ::std::uint64_t outBufferClientPtr))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReleasedFinalOutputRecorderBuffersAuto, (const ::nn::sf::OutBuffer& outFinalOutputRecorderBuffer, ::nn::sf::Out<::std::int32_t> count, ::nn::sf::Out<::std::int64_t> released))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFinalOutputRecorder)

        ::nn::Result GetFinalOutputRecorderState(::nn::sf::Out<::std::uint32_t> outFinalOutputRecorder) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFinalOutputRecorderState, (outFinalOutputRecorder));
        }

        ::nn::Result Start() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Start);
        }

        ::nn::Result Stop() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Stop);
        }

        ::nn::Result AppendFinalOutputRecorderBuffer(const ::nn::sf::InBuffer& outFinalOutputRecorderBuffer, ::std::uint64_t outBufferClientPtr) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AppendFinalOutputRecorderBuffer, (outFinalOutputRecorderBuffer, outBufferClientPtr));
        }

        ::nn::Result RegisterBufferEvent(::nn::sf::Out<::nn::sf::NativeHandle> bufferEvent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterBufferEvent, (bufferEvent));
        }

        ::nn::Result GetReleasedFinalOutputRecorderBuffers(const ::nn::sf::OutBuffer& outFinalOutputRecorderBuffer, ::nn::sf::Out<::std::int32_t> count, ::nn::sf::Out<::std::int64_t> released) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReleasedFinalOutputRecorderBuffers, (outFinalOutputRecorderBuffer, count, released));
        }

        ::nn::Result ContainsFinalOutputRecorderBuffer(::std::uint64_t FinalOutputRecorderBufferPointer, ::nn::sf::Out<bool> contains) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ContainsFinalOutputRecorderBuffer, (FinalOutputRecorderBufferPointer, contains));
        }

        ::nn::Result GetFinalOutputRecorderBufferEndTime(::std::uint64_t FinalOutputRecorderBufferPointer, ::nn::sf::Out<::std::int64_t> released) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFinalOutputRecorderBufferEndTime, (FinalOutputRecorderBufferPointer, released));
        }

        ::nn::Result AppendFinalOutputRecorderBufferAuto(const ::nn::sf::InBuffer& outFinalOutputRecorderBuffer, ::std::uint64_t outBufferClientPtr) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AppendFinalOutputRecorderBufferAuto, (outFinalOutputRecorderBuffer, outBufferClientPtr));
        }

        ::nn::Result GetReleasedFinalOutputRecorderBuffersAuto(const ::nn::sf::OutBuffer& outFinalOutputRecorderBuffer, ::nn::sf::Out<::std::int32_t> count, ::nn::sf::Out<::std::int64_t> released) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReleasedFinalOutputRecorderBuffersAuto, (outFinalOutputRecorderBuffer, count, released));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFinalOutputRecorder
    {
    public:
        nn::Result GetFinalOutputRecorderState(nn::sf::Out<std::uint32_t> outFinalOutputRecorder) NN_NOEXCEPT;
        nn::Result Start() NN_NOEXCEPT;
        nn::Result Stop() NN_NOEXCEPT;
        nn::Result AppendFinalOutputRecorderBuffer(const nn::sf::InBuffer& outFinalOutputRecorderBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT;
        nn::Result RegisterBufferEvent(nn::sf::Out<nn::sf::NativeHandle> bufferEvent) NN_NOEXCEPT;
        nn::Result GetReleasedFinalOutputRecorderBuffers(const nn::sf::OutBuffer& outFinalOutputRecorderBuffer, nn::sf::Out<std::int32_t> count, nn::sf::Out<std::int64_t> released) NN_NOEXCEPT;
        nn::Result ContainsFinalOutputRecorderBuffer(std::uint64_t FinalOutputRecorderBufferPointer, nn::sf::Out<bool> contains) NN_NOEXCEPT;
        nn::Result GetFinalOutputRecorderBufferEndTime(std::uint64_t FinalOutputRecorderBufferPointer, nn::sf::Out<std::int64_t> released) NN_NOEXCEPT;
        nn::Result AppendFinalOutputRecorderBufferAuto(const nn::sf::InBuffer& outFinalOutputRecorderBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT;
        nn::Result GetReleasedFinalOutputRecorderBuffersAuto(const nn::sf::OutBuffer& outFinalOutputRecorderBuffer, nn::sf::Out<std::int32_t> count, nn::sf::Out<std::int64_t> released) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetFinalOutputRecorderState(nn::sf::Out<std::uint32_t> outFinalOutputRecorder) NN_NOEXCEPT;
    nn::Result Start() NN_NOEXCEPT;
    nn::Result Stop() NN_NOEXCEPT;
    nn::Result AppendFinalOutputRecorderBuffer(const nn::sf::InBuffer& outFinalOutputRecorderBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT;
    nn::Result RegisterBufferEvent(nn::sf::Out<nn::sf::NativeHandle> bufferEvent) NN_NOEXCEPT;
    nn::Result GetReleasedFinalOutputRecorderBuffers(const nn::sf::OutBuffer& outFinalOutputRecorderBuffer, nn::sf::Out<std::int32_t> count, nn::sf::Out<std::int64_t> released) NN_NOEXCEPT;
    nn::Result ContainsFinalOutputRecorderBuffer(std::uint64_t FinalOutputRecorderBufferPointer, nn::sf::Out<bool> contains) NN_NOEXCEPT;
    nn::Result GetFinalOutputRecorderBufferEndTime(std::uint64_t FinalOutputRecorderBufferPointer, nn::sf::Out<std::int64_t> released) NN_NOEXCEPT;
    nn::Result AppendFinalOutputRecorderBufferAuto(const nn::sf::InBuffer& outFinalOutputRecorderBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT;
    nn::Result GetReleasedFinalOutputRecorderBuffersAuto(const nn::sf::OutBuffer& outFinalOutputRecorderBuffer, nn::sf::Out<std::int32_t> count, nn::sf::Out<std::int64_t> released) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::audio::detail::IFinalOutputRecorder))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFinalOutputRecorderState, (::nn::sf::Out<::std::uint32_t> outFinalOutputRecorder))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFinalOutputRecorderState, (outFinalOutputRecorder));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Start)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Start);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Stop)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Stop);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AppendFinalOutputRecorderBuffer, (const ::nn::sf::InBuffer& outFinalOutputRecorderBuffer, ::std::uint64_t outBufferClientPtr))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AppendFinalOutputRecorderBuffer, (outFinalOutputRecorderBuffer, outBufferClientPtr));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBufferEvent, (::nn::sf::Out<::nn::sf::NativeHandle> bufferEvent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterBufferEvent, (bufferEvent));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReleasedFinalOutputRecorderBuffers, (const ::nn::sf::OutBuffer& outFinalOutputRecorderBuffer, ::nn::sf::Out<::std::int32_t> count, ::nn::sf::Out<::std::int64_t> released))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReleasedFinalOutputRecorderBuffers, (outFinalOutputRecorderBuffer, count, released));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ContainsFinalOutputRecorderBuffer, (::std::uint64_t FinalOutputRecorderBufferPointer, ::nn::sf::Out<bool> contains))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ContainsFinalOutputRecorderBuffer, (FinalOutputRecorderBufferPointer, contains));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFinalOutputRecorderBufferEndTime, (::std::uint64_t FinalOutputRecorderBufferPointer, ::nn::sf::Out<::std::int64_t> released))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFinalOutputRecorderBufferEndTime, (FinalOutputRecorderBufferPointer, released));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AppendFinalOutputRecorderBufferAuto, (const ::nn::sf::InBuffer& outFinalOutputRecorderBuffer, ::std::uint64_t outBufferClientPtr))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AppendFinalOutputRecorderBufferAuto, (outFinalOutputRecorderBuffer, outBufferClientPtr));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReleasedFinalOutputRecorderBuffersAuto, (const ::nn::sf::OutBuffer& outFinalOutputRecorderBuffer, ::nn::sf::Out<::std::int32_t> count, ::nn::sf::Out<::std::int64_t> released))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReleasedFinalOutputRecorderBuffersAuto, (outFinalOutputRecorderBuffer, count, released));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::audio::detail::IFinalOutputRecorder>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::audio::detail::IFinalOutputRecorder))

    // nn::Result GetFinalOutputRecorderState(nn::sf::Out<std::uint32_t> outFinalOutputRecorder) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFinalOutputRecorderState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFinalOutputRecorder, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outFinalOutputRecorder))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFinalOutputRecorder)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFinalOutputRecorderState)

    // nn::Result Start() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Start)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Start)

    // nn::Result Stop() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Stop)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Stop)

    // nn::Result AppendFinalOutputRecorderBuffer(const nn::sf::InBuffer& outFinalOutputRecorderBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AppendFinalOutputRecorderBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outFinalOutputRecorderBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outFinalOutputRecorderBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferClientPtr, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (outBufferClientPtr))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFinalOutputRecorderBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferClientPtr)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AppendFinalOutputRecorderBuffer)

    // nn::Result RegisterBufferEvent(nn::sf::Out<nn::sf::NativeHandle> bufferEvent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterBufferEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(bufferEvent, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (bufferEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferEvent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterBufferEvent)

    // nn::Result GetReleasedFinalOutputRecorderBuffers(const nn::sf::OutBuffer& outFinalOutputRecorderBuffer, nn::sf::Out<std::int32_t> count, nn::sf::Out<std::int64_t> released) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReleasedFinalOutputRecorderBuffers)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outFinalOutputRecorderBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outFinalOutputRecorderBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(count, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(released, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (count, released))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFinalOutputRecorderBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(released)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReleasedFinalOutputRecorderBuffers)

    // nn::Result ContainsFinalOutputRecorderBuffer(std::uint64_t FinalOutputRecorderBufferPointer, nn::sf::Out<bool> contains) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ContainsFinalOutputRecorderBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(FinalOutputRecorderBufferPointer, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (FinalOutputRecorderBufferPointer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(contains, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (contains))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FinalOutputRecorderBufferPointer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contains)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ContainsFinalOutputRecorderBuffer)

    // nn::Result GetFinalOutputRecorderBufferEndTime(std::uint64_t FinalOutputRecorderBufferPointer, nn::sf::Out<std::int64_t> released) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFinalOutputRecorderBufferEndTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(FinalOutputRecorderBufferPointer, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (FinalOutputRecorderBufferPointer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(released, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (released))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FinalOutputRecorderBufferPointer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(released)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFinalOutputRecorderBufferEndTime)

    // nn::Result AppendFinalOutputRecorderBufferAuto(const nn::sf::InBuffer& outFinalOutputRecorderBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AppendFinalOutputRecorderBufferAuto)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outFinalOutputRecorderBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outFinalOutputRecorderBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(outBufferClientPtr, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (outBufferClientPtr))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFinalOutputRecorderBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferClientPtr)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AppendFinalOutputRecorderBufferAuto)

    // nn::Result GetReleasedFinalOutputRecorderBuffersAuto(const nn::sf::OutBuffer& outFinalOutputRecorderBuffer, nn::sf::Out<std::int32_t> count, nn::sf::Out<std::int64_t> released) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReleasedFinalOutputRecorderBuffersAuto)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outFinalOutputRecorderBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outFinalOutputRecorderBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(count, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(released, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (count, released))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFinalOutputRecorderBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(released)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReleasedFinalOutputRecorderBuffersAuto)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::audio::detail::IFinalOutputRecorder, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::audio::detail::IFinalOutputRecorder))

    // nn::Result GetFinalOutputRecorderState(nn::sf::Out<std::uint32_t> outFinalOutputRecorder) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFinalOutputRecorderState, (::nn::sf::Out<::std::uint32_t> outFinalOutputRecorder))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFinalOutputRecorderState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFinalOutputRecorder)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFinalOutputRecorderState)
    }

    // nn::Result Start() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Start)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Start)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Start)
    }

    // nn::Result Stop() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Stop)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Stop)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Stop)
    }

    // nn::Result AppendFinalOutputRecorderBuffer(const nn::sf::InBuffer& outFinalOutputRecorderBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AppendFinalOutputRecorderBuffer, (const ::nn::sf::InBuffer& outFinalOutputRecorderBuffer, ::std::uint64_t outBufferClientPtr))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AppendFinalOutputRecorderBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFinalOutputRecorderBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferClientPtr)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AppendFinalOutputRecorderBuffer)
    }

    // nn::Result RegisterBufferEvent(nn::sf::Out<nn::sf::NativeHandle> bufferEvent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBufferEvent, (::nn::sf::Out<::nn::sf::NativeHandle> bufferEvent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterBufferEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterBufferEvent)
    }

    // nn::Result GetReleasedFinalOutputRecorderBuffers(const nn::sf::OutBuffer& outFinalOutputRecorderBuffer, nn::sf::Out<std::int32_t> count, nn::sf::Out<std::int64_t> released) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReleasedFinalOutputRecorderBuffers, (const ::nn::sf::OutBuffer& outFinalOutputRecorderBuffer, ::nn::sf::Out<::std::int32_t> count, ::nn::sf::Out<::std::int64_t> released))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReleasedFinalOutputRecorderBuffers)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFinalOutputRecorderBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(released)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReleasedFinalOutputRecorderBuffers)
    }

    // nn::Result ContainsFinalOutputRecorderBuffer(std::uint64_t FinalOutputRecorderBufferPointer, nn::sf::Out<bool> contains) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ContainsFinalOutputRecorderBuffer, (::std::uint64_t FinalOutputRecorderBufferPointer, ::nn::sf::Out<bool> contains))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ContainsFinalOutputRecorderBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FinalOutputRecorderBufferPointer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contains)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ContainsFinalOutputRecorderBuffer)
    }

    // nn::Result GetFinalOutputRecorderBufferEndTime(std::uint64_t FinalOutputRecorderBufferPointer, nn::sf::Out<std::int64_t> released) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFinalOutputRecorderBufferEndTime, (::std::uint64_t FinalOutputRecorderBufferPointer, ::nn::sf::Out<::std::int64_t> released))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFinalOutputRecorderBufferEndTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FinalOutputRecorderBufferPointer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(released)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFinalOutputRecorderBufferEndTime)
    }

    // nn::Result AppendFinalOutputRecorderBufferAuto(const nn::sf::InBuffer& outFinalOutputRecorderBuffer, std::uint64_t outBufferClientPtr) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AppendFinalOutputRecorderBufferAuto, (const ::nn::sf::InBuffer& outFinalOutputRecorderBuffer, ::std::uint64_t outBufferClientPtr))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AppendFinalOutputRecorderBufferAuto)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFinalOutputRecorderBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferClientPtr)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AppendFinalOutputRecorderBufferAuto)
    }

    // nn::Result GetReleasedFinalOutputRecorderBuffersAuto(const nn::sf::OutBuffer& outFinalOutputRecorderBuffer, nn::sf::Out<std::int32_t> count, nn::sf::Out<std::int64_t> released) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReleasedFinalOutputRecorderBuffersAuto, (const ::nn::sf::OutBuffer& outFinalOutputRecorderBuffer, ::nn::sf::Out<::std::int32_t> count, ::nn::sf::Out<::std::int64_t> released))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReleasedFinalOutputRecorderBuffersAuto)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFinalOutputRecorderBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(released)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReleasedFinalOutputRecorderBuffersAuto)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::audio::detail::IFinalOutputRecorder>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::audio::detail::IFinalOutputRecorder))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFinalOutputRecorderState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFinalOutputRecorderState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFinalOutputRecorder)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Start)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Start)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Stop)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Stop)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AppendFinalOutputRecorderBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outFinalOutputRecorderBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AppendFinalOutputRecorderBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outFinalOutputRecorderBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferClientPtr)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterBufferEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(bufferEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterBufferEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(bufferEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReleasedFinalOutputRecorderBuffers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outFinalOutputRecorderBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReleasedFinalOutputRecorderBuffers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outFinalOutputRecorderBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(count),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(released)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ContainsFinalOutputRecorderBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ContainsFinalOutputRecorderBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(FinalOutputRecorderBufferPointer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(contains)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFinalOutputRecorderBufferEndTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFinalOutputRecorderBufferEndTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(FinalOutputRecorderBufferPointer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(released)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AppendFinalOutputRecorderBufferAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outFinalOutputRecorderBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AppendFinalOutputRecorderBufferAuto)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outFinalOutputRecorderBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(outBufferClientPtr)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReleasedFinalOutputRecorderBuffersAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outFinalOutputRecorderBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReleasedFinalOutputRecorderBuffersAuto)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outFinalOutputRecorderBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(count),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(released)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFinalOutputRecorderState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Start)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Stop)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AppendFinalOutputRecorderBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterBufferEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReleasedFinalOutputRecorderBuffers)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ContainsFinalOutputRecorderBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFinalOutputRecorderBufferEndTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AppendFinalOutputRecorderBufferAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReleasedFinalOutputRecorderBuffersAuto)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::audio::detail::IFinalOutputRecorder))
