﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/audio/detail/audio_AudioRendererTypesInternal.h>
#include <nn/audio/detail/audio_IAudioDevice.h>
#include <nn/audio/detail/audio_IAudioRenderer.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace audio { namespace detail { // NOLINT(whitespace/braces)

class IAudioRendererManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAudioRendererManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAudioRendererManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioRenderer, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioRenderer>> outAudioRenderer, const ::nn::audio::detail::AudioRendererParameterInternal& parameter, ::nn::sf::NativeHandle&& workBufferHandle, ::nn::sf::NativeHandle&& processHandle, ::std::uint64_t size, ::nn::applet::AppletResourceUserId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetWorkBufferSize, (::nn::sf::Out<::std::int64_t> size, const ::nn::audio::detail::AudioRendererParameterInternal& parameter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioDeviceService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioDevice>> outAudioDeviceService, ::nn::applet::AppletResourceUserId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioRendererForManualExecution, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioRenderer>> outAudioRenderer, const ::nn::audio::detail::AudioRendererParameterInternal& parameter, ::std::uint64_t workBufferAddress, ::nn::sf::NativeHandle&& processHandle, ::std::uint64_t size, ::nn::applet::AppletResourceUserId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioDeviceServiceWithRevisionInfo, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioDevice>> outAudioDeviceService, ::nn::applet::AppletResourceUserId id, ::std::uint32_t revisionInfo))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAudioRendererManager)

        ::nn::Result OpenAudioRenderer(::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioRenderer>> outAudioRenderer, const ::nn::audio::detail::AudioRendererParameterInternal& parameter, ::nn::sf::NativeHandle&& workBufferHandle, ::nn::sf::NativeHandle&& processHandle, ::std::uint64_t size, ::nn::applet::AppletResourceUserId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenAudioRenderer, (outAudioRenderer, parameter, ::std::move(workBufferHandle), ::std::move(processHandle), size, id));
        }

        ::nn::Result GetWorkBufferSize(::nn::sf::Out<::std::int64_t> size, const ::nn::audio::detail::AudioRendererParameterInternal& parameter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetWorkBufferSize, (size, parameter));
        }

        ::nn::Result GetAudioDeviceService(::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioDevice>> outAudioDeviceService, ::nn::applet::AppletResourceUserId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAudioDeviceService, (outAudioDeviceService, id));
        }

        ::nn::Result OpenAudioRendererForManualExecution(::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioRenderer>> outAudioRenderer, const ::nn::audio::detail::AudioRendererParameterInternal& parameter, ::std::uint64_t workBufferAddress, ::nn::sf::NativeHandle&& processHandle, ::std::uint64_t size, ::nn::applet::AppletResourceUserId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenAudioRendererForManualExecution, (outAudioRenderer, parameter, workBufferAddress, ::std::move(processHandle), size, id));
        }

        ::nn::Result GetAudioDeviceServiceWithRevisionInfo(::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioDevice>> outAudioDeviceService, ::nn::applet::AppletResourceUserId id, ::std::uint32_t revisionInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAudioDeviceServiceWithRevisionInfo, (outAudioDeviceService, id, revisionInfo));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAudioRendererManager
    {
    public:
        nn::Result OpenAudioRenderer(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioRenderer>> outAudioRenderer, const nn::audio::detail::AudioRendererParameterInternal& parameter, nn::sf::NativeHandle&& workBufferHandle, nn::sf::NativeHandle&& processHandle, std::uint64_t size, nn::applet::AppletResourceUserId id) NN_NOEXCEPT;
        nn::Result GetWorkBufferSize(nn::sf::Out<std::int64_t> size, const nn::audio::detail::AudioRendererParameterInternal& parameter) NN_NOEXCEPT;
        nn::Result GetAudioDeviceService(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioDevice>> outAudioDeviceService, nn::applet::AppletResourceUserId id) NN_NOEXCEPT;
        nn::Result OpenAudioRendererForManualExecution(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioRenderer>> outAudioRenderer, const nn::audio::detail::AudioRendererParameterInternal& parameter, std::uint64_t workBufferAddress, nn::sf::NativeHandle&& processHandle, std::uint64_t size, nn::applet::AppletResourceUserId id) NN_NOEXCEPT;
        nn::Result GetAudioDeviceServiceWithRevisionInfo(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioDevice>> outAudioDeviceService, nn::applet::AppletResourceUserId id, std::uint32_t revisionInfo) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result OpenAudioRenderer(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioRenderer>> outAudioRenderer, const nn::audio::detail::AudioRendererParameterInternal& parameter, nn::sf::NativeHandle&& workBufferHandle, nn::sf::NativeHandle&& processHandle, std::uint64_t size, nn::applet::AppletResourceUserId id) NN_NOEXCEPT;
    nn::Result GetWorkBufferSize(nn::sf::Out<std::int64_t> size, const nn::audio::detail::AudioRendererParameterInternal& parameter) NN_NOEXCEPT;
    nn::Result GetAudioDeviceService(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioDevice>> outAudioDeviceService, nn::applet::AppletResourceUserId id) NN_NOEXCEPT;
    nn::Result OpenAudioRendererForManualExecution(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioRenderer>> outAudioRenderer, const nn::audio::detail::AudioRendererParameterInternal& parameter, std::uint64_t workBufferAddress, nn::sf::NativeHandle&& processHandle, std::uint64_t size, nn::applet::AppletResourceUserId id) NN_NOEXCEPT;
    nn::Result GetAudioDeviceServiceWithRevisionInfo(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioDevice>> outAudioDeviceService, nn::applet::AppletResourceUserId id, std::uint32_t revisionInfo) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::audio::detail::IAudioRendererManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioRenderer, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioRenderer>> outAudioRenderer, const ::nn::audio::detail::AudioRendererParameterInternal& parameter, ::nn::sf::NativeHandle&& workBufferHandle, ::nn::sf::NativeHandle&& processHandle, ::std::uint64_t size, ::nn::applet::AppletResourceUserId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenAudioRenderer, (outAudioRenderer, parameter, ::std::move(workBufferHandle), ::std::move(processHandle), size, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetWorkBufferSize, (::nn::sf::Out<::std::int64_t> size, const ::nn::audio::detail::AudioRendererParameterInternal& parameter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetWorkBufferSize, (size, parameter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioDeviceService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioDevice>> outAudioDeviceService, ::nn::applet::AppletResourceUserId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAudioDeviceService, (outAudioDeviceService, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioRendererForManualExecution, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioRenderer>> outAudioRenderer, const ::nn::audio::detail::AudioRendererParameterInternal& parameter, ::std::uint64_t workBufferAddress, ::nn::sf::NativeHandle&& processHandle, ::std::uint64_t size, ::nn::applet::AppletResourceUserId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenAudioRendererForManualExecution, (outAudioRenderer, parameter, workBufferAddress, ::std::move(processHandle), size, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioDeviceServiceWithRevisionInfo, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioDevice>> outAudioDeviceService, ::nn::applet::AppletResourceUserId id, ::std::uint32_t revisionInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAudioDeviceServiceWithRevisionInfo, (outAudioDeviceService, id, revisionInfo));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::audio::detail::IAudioRendererManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::audio::detail::IAudioRendererManager))

    // nn::Result OpenAudioRenderer(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioRenderer>> outAudioRenderer, const nn::audio::detail::AudioRendererParameterInternal& parameter, nn::sf::NativeHandle&& workBufferHandle, nn::sf::NativeHandle&& processHandle, std::uint64_t size, nn::applet::AppletResourceUserId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenAudioRenderer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAudioRenderer, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAudioRenderer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(workBufferHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(processHandle, 1, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(2, (workBufferHandle, processHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(parameter, (::nn::audio::detail::AudioRendererParameterInternal), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint64_t), 56)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::applet::AppletResourceUserId), 64)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (parameter, size, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioRenderer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(parameter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBufferHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenAudioRenderer)

    // nn::Result GetWorkBufferSize(nn::sf::Out<std::int64_t> size, const nn::audio::detail::AudioRendererParameterInternal& parameter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetWorkBufferSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(parameter, (::nn::audio::detail::AudioRendererParameterInternal), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (parameter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(52)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(size, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(parameter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetWorkBufferSize)

    // nn::Result GetAudioDeviceService(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioDevice>> outAudioDeviceService, nn::applet::AppletResourceUserId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAudioDeviceService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAudioDeviceService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAudioDeviceService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioDeviceService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAudioDeviceService)

    // nn::Result OpenAudioRendererForManualExecution(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioRenderer>> outAudioRenderer, const nn::audio::detail::AudioRendererParameterInternal& parameter, std::uint64_t workBufferAddress, nn::sf::NativeHandle&& processHandle, std::uint64_t size, nn::applet::AppletResourceUserId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenAudioRendererForManualExecution)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAudioRenderer, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAudioRenderer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(processHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (processHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(parameter, (::nn::audio::detail::AudioRendererParameterInternal), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(workBufferAddress, (::std::uint64_t), 56)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint64_t), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::applet::AppletResourceUserId), 72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (parameter, workBufferAddress, size, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioRenderer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(parameter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBufferAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenAudioRendererForManualExecution)

    // nn::Result GetAudioDeviceServiceWithRevisionInfo(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioDevice>> outAudioDeviceService, nn::applet::AppletResourceUserId id, std::uint32_t revisionInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAudioDeviceServiceWithRevisionInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAudioDeviceService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAudioDeviceService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(revisionInfo, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (revisionInfo, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAudioDeviceService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(revisionInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAudioDeviceServiceWithRevisionInfo)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::audio::detail::AudioRendererParameterInternal), 52, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::audio::detail::IAudioRendererManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::audio::detail::IAudioRendererManager))

    // nn::Result OpenAudioRenderer(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioRenderer>> outAudioRenderer, const nn::audio::detail::AudioRendererParameterInternal& parameter, nn::sf::NativeHandle&& workBufferHandle, nn::sf::NativeHandle&& processHandle, std::uint64_t size, nn::applet::AppletResourceUserId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioRenderer, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioRenderer>> outAudioRenderer, const ::nn::audio::detail::AudioRendererParameterInternal& parameter, ::nn::sf::NativeHandle&& workBufferHandle, ::nn::sf::NativeHandle&& processHandle, ::std::uint64_t size, ::nn::applet::AppletResourceUserId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenAudioRenderer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioRenderer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(parameter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBufferHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenAudioRenderer)
    }

    // nn::Result GetWorkBufferSize(nn::sf::Out<std::int64_t> size, const nn::audio::detail::AudioRendererParameterInternal& parameter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetWorkBufferSize, (::nn::sf::Out<::std::int64_t> size, const ::nn::audio::detail::AudioRendererParameterInternal& parameter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetWorkBufferSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(parameter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetWorkBufferSize)
    }

    // nn::Result GetAudioDeviceService(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioDevice>> outAudioDeviceService, nn::applet::AppletResourceUserId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioDeviceService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioDevice>> outAudioDeviceService, ::nn::applet::AppletResourceUserId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAudioDeviceService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioDeviceService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAudioDeviceService)
    }

    // nn::Result OpenAudioRendererForManualExecution(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioRenderer>> outAudioRenderer, const nn::audio::detail::AudioRendererParameterInternal& parameter, std::uint64_t workBufferAddress, nn::sf::NativeHandle&& processHandle, std::uint64_t size, nn::applet::AppletResourceUserId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAudioRendererForManualExecution, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioRenderer>> outAudioRenderer, const ::nn::audio::detail::AudioRendererParameterInternal& parameter, ::std::uint64_t workBufferAddress, ::nn::sf::NativeHandle&& processHandle, ::std::uint64_t size, ::nn::applet::AppletResourceUserId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenAudioRendererForManualExecution)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioRenderer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(parameter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBufferAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenAudioRendererForManualExecution)
    }

    // nn::Result GetAudioDeviceServiceWithRevisionInfo(nn::sf::Out<nn::sf::SharedPointer<nn::audio::detail::IAudioDevice>> outAudioDeviceService, nn::applet::AppletResourceUserId id, std::uint32_t revisionInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioDeviceServiceWithRevisionInfo, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::audio::detail::IAudioDevice>> outAudioDeviceService, ::nn::applet::AppletResourceUserId id, ::std::uint32_t revisionInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAudioDeviceServiceWithRevisionInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAudioDeviceService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(revisionInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAudioDeviceServiceWithRevisionInfo)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::audio::detail::IAudioRendererManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::audio::detail::IAudioRendererManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenAudioRenderer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(workBufferHandle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(processHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::audio::detail::IAudioRenderer>), outAudioRenderer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenAudioRenderer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAudioRenderer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(parameter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(workBufferHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(processHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAudioRenderer, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetWorkBufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetWorkBufferSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(size),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(parameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAudioDeviceService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::audio::detail::IAudioDevice>), outAudioDeviceService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAudioDeviceService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAudioDeviceService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAudioDeviceService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenAudioRendererForManualExecution)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(processHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::audio::detail::IAudioRenderer>), outAudioRenderer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenAudioRendererForManualExecution)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAudioRenderer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(parameter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(workBufferAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(processHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAudioRenderer, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAudioDeviceServiceWithRevisionInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::audio::detail::IAudioDevice>), outAudioDeviceService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAudioDeviceServiceWithRevisionInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAudioDeviceService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(revisionInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAudioDeviceService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenAudioRenderer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetWorkBufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAudioDeviceService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenAudioRendererForManualExecution)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAudioDeviceServiceWithRevisionInfo)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::audio::detail::IAudioRendererManager))
