﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/os/os_MemoryHeapCommon.h>
#include <nn/os/os_Mutex.h>
#include <nn/audio/audio_SampleFormat.h>
#include <nn/audio/audio_AudioInOutCommonTypes.h>
#include <nn/os/os_SystemEvent.h>

namespace nn {
namespace audio{

enum FinalOutputRecorderState
{
    FinalOutputRecorderState_Started,
    FinalOutputRecorderState_Stopped,
};

struct FinalOutputRecorderParameter
{
    int32_t sampleRate;
    int32_t channelCount;
};

struct FinalOutputRecorderBuffer
{
    static const size_t AddressAlignment = nn::os::MemoryPageSize; //!< AudioInBuffer に要求されるアライメント
    static const size_t SizeGranularity = nn::os::MemoryPageSize;  //!< AudioInBuffer に要求されるサイズの粒度
    nn::TimeSpan released;
    union
    {
        FinalOutputRecorderBuffer* pNext;
        uint64_t _pNextU64;
    };
    union
    {
        void* buffer;
        uint64_t _bufferU64;
    };
    union
    {
        size_t bufferSize;
        uint64_t _bufferSizeU64;
    };
    union
    {
        size_t size;
        uint64_t _sizeU64;
    };
    union
    {
       size_t offset;
       uint64_t _offsetU64;
    };
};

typedef AudioBufferList<FinalOutputRecorderBuffer> FinalOutputRecorderBufferList;

#define NN_AUDIO_ALIGNAS_FINAL_OUTPUT_RECORDER_BUFFER_ALIGN NN_ALIGNAS(4096)

struct FinalOutputRecorder
{
    int32_t sampleRate;
    int32_t channelCount;
    SampleFormat sampleFormat;
    FinalOutputRecorderState state;

    bool isMutexInitialized;
    mutable os::MutexType mutex;
    FinalOutputRecorderBufferList appendList;
    FinalOutputRecorderBufferList releaseList;

    int32_t internalBufferSampleCount;
    void* pDevice;
    void* pAudioClient;
    void* pAudioCaptureClient;
    void* hEvent;
};

const int FinalOutputRecorderCountMax = 2;
} //namespace audio
} //namespace nn
