﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_SystemEvent.h>
#include <nn/audio/audio_Result.h>
#include <nn/audio/audio_AudioRendererTypes.h>

namespace nn {
namespace audio {

/**
 * @name        オーディオレンダラ
 * @{
 */

/**
 * @internal
 * @brief           メモリプールによる範囲チェックの有効無効を設定します。
 * @param[in]       pOutConfig          設定するオーディオレンダラに紐づく AudioRendererConfig
 * @param[in]       enabled             有効無効の設定。false を指定すると無効になります。
 * @pre
 * - pOutConfig は初期化されている。
 * @details
 * NintendoSDK 0.15.0 から nn::audio::MemoryPoolType によるメモリ領域の範囲チェックが有効になりました。
 * このチェックでは nn::audio::MemoryPoolType に含まれているべき各種バッファに対して、
 * それぞれが何れかのアタッチ状態の MemoryPoolType に含まれているかどうかをチェックしています。
 *
 * この関数では、このチェックの有効無効を切り替えます。
 * enabled に false を指定してこの関数を呼び出した以後は上記チェックが無効化され NintendoSDK 0.14.0 までと同様の挙動となります。
 * @confluencelink{124010227, メモリプールの説明ページも併せて参照してください。}
 */
void SetMemoryPoolErrorCheckEnabled(AudioRendererConfig* pOutConfig, bool enabled) NN_NOEXCEPT;

/**
 * @internal
 * @brief           メモリプールによる領域チェックの有効無効を状態を取得します。
 * @param[out]      pOutConfig     設定するオーディオレンダラに紐づく AudioRendererConfig
 * @return          有効無効状態を返します。  true で有効状態です。
 * @details
 * デフォルトでは true を返します。
 * @confluencelink{124010227, メモリプールの説明ページも併せて参照してください。}
 */
bool IsMemoryPoolErrorCheckEnabled(const AudioRendererConfig* pOutConfig) NN_NOEXCEPT;

/**
 * @}
 */
}  // namespace audio
}  // namespace nn
