﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/applet/applet_Types.h>
#include <nn/applet/applet_Storage.h>
#include <nn/ncm/ncm_ContentMetaId.h>

namespace nn { namespace applet {

//! @name アプリケーション起動時パラメータ取得
//! @{

/**
    @brief アプリケーションに渡された起動時パラメータを取得します。

    @param[out] pOut 取得されたハンドルを格納する領域を指定します。
    @param[in] launchParameterKind パラメータの種類

    @return 取得できたとき true を、そうでないとき false を返します。

    @details
     アプリケーションに渡された launchParameterKind で指定された種類の起動時パラメータがあれば、
     それを取得し *pOut にそのハンドルを格納し、true を返します。

     指定された種類の起動時パラメータがなければ、false を返します。
*/
bool TryPopFromApplicationParameterChannel(StorageHandle* pOut, LaunchParameterKind launchParameterKind) NN_NOEXCEPT;

//! @}

//! @name (暫定) アプリケーションからのアプリケーション起動要求
//! @{

/**
    @brief (暫定) アプリケーションの再起動要求を出します。

    @param[in] storageHandle 再起動時の LaunchParameterKind_User として取得できるストレージのハンドルを指定します。

    @details
     この関数は暫定です。
     最終的にアプリケーション開発者に公開される際には別のライブラリの関数として公開される予定です。
     なお、その場合には、本関数が内部実装として使用される予定です。

     本関数のを呼んだアプリケーションの ApplicationId が暗黙で指定されることを除いて、
     RequestToLaunchApplication() と同様の動作を行います。

     なお、本関数は暫定であり、本関数を呼んでも、呼び元のアプリケーションは自動では終了しません。
     本関数を使用した開発を行う場合には、必要に応じて、自発的に終了させたり、システムアプレットから終了させたりする必要があります。
*/
void RequestToRelaunchApplication(StorageHandle storageHandle) NN_NOEXCEPT;

/**
    @brief (暫定) アプリケーションの起動要求を出します。

    @param[in] applicationId 起動要求を出すアプリケーションの applicationId を指定します。
    @param[in] storageHandle 再起動時の LaunchParameterKind_User として取得できるストレージのハンドルを指定します。

    @details
     この関数は暫定です。
     最終的にアプリケーション開発者に公開される際には別のライブラリの関数として公開される予定です。
     なお、その場合には、本関数が内部実装として使用される予定です。

     この関数を呼ぶとシステム内で以下のような処理が行われます。

     - ae::CreateApplication(applicationId) 相当の処理 → アプリケーションハンドル handle を取得
     - ae::PushApplicationLaunchParameter(handle, LaunchParameterKind_User, storageHandle) 相当の処理
     - ae::TryPopLaunchRequestedApplication() の対象のキューに handle をエンキュー
     - ae::Message_LaunchApplicationRequested を通知

     この結果、

     - システムアプレットに ae::Message_LaunchApplicationRequested が通知される
     - システムアプレットで ae::TryPopLaunchRequestedApplication() でアプリケーションハンドルを取得できる
     - システムアプレットで、取得したハンドルに対し ae::GetApplicationId() を呼ぶことで applicationId が取得できる
     - ae::StartApplication() で開始すると、そのアプリケーションプログラム内で TryPopFromApplicationParameterChannel(LaunchParameterKind_User) を呼ぶことで storageHandle で指定したストレージが取得できる

     となります。

     なお、本関数は暫定であり、本関数を呼んでも、呼び元のアプリケーションは自動では終了しません。
     本関数を使用した開発を行う場合には、必要に応じて、自発的に終了させたり、システムアプレットから終了させたりする必要があります。
*/
void RequestToLaunchApplication(ncm::ApplicationId applicationId, StorageHandle storageHandle) NN_NOEXCEPT;

//! @}

}}
