﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/applet/applet_Storage.h>

namespace nn { namespace applet {

//! @name システムアプレットへの通知
//! @{

/**
    @brief システムの汎用チャンネルにストレージを push します。

    @param[in] storageHandle push するストレージのハンドルを指定します。

    @details
     システムの汎用チャンネルにストレージを push します。
     システムアプレットがこれを受け取ります。

     この関数はアプリケーションプログラムからは呼ぶことができません。
*/
void PushToSystemGeneralChannel(StorageHandle storageHandle) NN_NOEXCEPT;

//! @}

//! @name VR モードの変更
//! @{

/**
    @brief VR モードを開始します。

    @details
     VR モードを開始します。本 API はネスト管理されません。
     VR モードを終了するには、EndVrModeInternal() を発行して下さい。

     本 API や EndVrModeInternal() によって VR モードが変更されると、
     全てのアプレットに対して nn::ae::Message_VrModeChanged が通知されます。
     詳細は nn::ae::IsVrMode() も合わせて参照して下さい。

     この関数は本体機能開発者が開発用に使用するためのものです。
     アプリケーション開発者には本 API をラップした専用の API が
     別途 nn::pl に用意されます。

*/
void BeginVrModeInternal() NN_NOEXCEPT;

/**
    @brief VR モードを終了します。

    @details
     VR モードを終了します。本 API はネスト管理されません。
     詳細は BeginVrModeInternal() を参照して下さい。

*/
void EndVrModeInternal() NN_NOEXCEPT;

//! @}

}}
