﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief 性能を操作する APM サーバライブラリの API 宣言。
 */

#pragma once

namespace nn { namespace apm { namespace server {

/**
 * @brief APM サーバーライブラリを初期化します。
 *
 * @post        ライブラリは初期化済の状態になります。
 * @details     APM サーバーライブラリを初期化します。
 */
void Initialize() NN_NOEXCEPT;

/**
 * @brief APM サーバーライブラリを終了します。
 *
 * @post        ライブラリは初期化前の状態になります。
 * @details     APM サーバーライブラリを終了します。
 */
void Finalize() NN_NOEXCEPT;

}}} // namepsace nn::apm::server
