﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief APM ライブラリのシステム開発者向け機能のマネージャの実装クラス。
 */

#pragma once

#include <nn/apm/apm_ISystemManager.sfdl.h>
#include <nn/os.h>

namespace nn { namespace apm {

// ISystemManager 実装クラス
class SystemManagerImpl : public nn::sf::ISharedObject
{
public:
    nn::Result RequestPerformanceMode(nn::apm::PerformanceMode performanceMode) NN_NOEXCEPT;
    nn::Result GetPerformanceEvent(nn::sf::Out<nn::sf::NativeHandle> pOutNativeHandle, nn::apm::EventTarget eventTarget) NN_NOEXCEPT;
    nn::Result GetThrottlingState(nn::sf::Out<nn::apm::ThrottlingState> pOutThrottlingState) NN_NOEXCEPT;
    nn::Result GetLastThrottlingState(nn::sf::Out<nn::apm::ThrottlingState> pOutThrottlingState) NN_NOEXCEPT;
    nn::Result ClearLastThrottlingState() NN_NOEXCEPT;
    nn::Result LoadAndApplySettings() NN_NOEXCEPT;
};

}} // namespace nn::apm
