﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  追加コンテンツの API 宣言
*/

#pragma once

#include <nn/aoc/aoc_Types.h>
#include <nn/nn_ApplicationId.h>

namespace nn { namespace aoc {

//! @name 追加コンテンツの列挙
//! @{

    /**
     * @brief   インストール済みで権利を保有する追加コンテンツの数を返します。
     *
     * @param[in]   target  調査対象の追加コンテンツと紐づくアプリケーションのアプリケーションID を指定します。
     *
     * @return  インストール済みで権利を保有する追加コンテンツの数が返ります。
     *
     * @pre
     *  - @ref nn::aoc::Initialize による初期化が完了している。
     *
     * @details
     *  target で指定したアプリケーションに紐づく追加コンテンツで
     *  インストール済みで権利を保有する追加コンテンツの数を取得します。
     */
    int CountAddOnContent(ApplicationId targetApplication) NN_NOEXCEPT;


    /**
     * @brief   インストール済みで権利を保有する追加コンテンツの追加コンテンツインデックスを列挙します。
     *
     * @param[out]  outIndices      列挙されたインデックスの格納先バッファ。
     * @param[in]   offset          列挙する追加コンテンツインデックスのオフセットを指定します。
     * @param[in]   count           列挙する最大数を指定します。
     * @param[in]   target          列挙対象の追加コンテンツと紐づくアプリケーションのアプリケーションID を指定します。
     *
     * @return  列挙した追加コンテンツインデックスの数が返ります。
     *
     * @pre
     *  - @ref nn::aoc::Initialize による初期化が完了している。
     *  - outIndices の最大要素数 >= count
     *  - offset >= 0
     *
     * @details
     *  target で指定したアプリケーションに紐づく、インストール済みで権利を保有する
     *  追加コンテンツの追加コンテンツインデックスを列挙します。
     *  列挙された追加コンテンツインデックスの offset 番目から count で指定された数の
     *  追加コンテンツインデックスを outIndices に格納します。
     *  outIndices で指定したバッファの要素数を超える count を指定した場合の動作は未定義です。
     */
    int ListAddOnContent(   AddOnContentIndex*  outIndices,
                            int                 offset,
                            int                 count,
                            ApplicationId       targetApplication) NN_NOEXCEPT;

//! @}
}} // namespace nn::aoc
