﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/am/service/window/am_WindowControllerBase.h>

#include <nn/util/util_Exchange.h>
#include <nn/idle/idle_SystemTypes.h>
#include <nn/nn_TimeSpan.h>

namespace nn { namespace am { namespace service { namespace window {

class IdleWindowController
     : public WindowControllerBase<IdleWindowController>
{
public:

    // Status という名前でデータ構造を定義
    struct Status
    {
        bool shouldSetHandlingContext;
        uint64_t updateCount;
    };

    // active でないときの Status を初期化する関数
    static void SetNotActive(Status* p) NN_NOEXCEPT
    {
        p->shouldSetHandlingContext = false;
        p->updateCount = 0;
    }

    // これが true を返す場合は Update 系関数は呼ばれない
    static bool AreEqual(const Status& x, const Status& y) NN_NOEXCEPT
    {
        return true
            && x.shouldSetHandlingContext == y.shouldSetHandlingContext
            && x.updateCount == y.updateCount;
    }

    struct Property
    {
        bool needsSetHandlingContext;
        uint64_t updateCount;
    };

    struct CalculationContext
    {
        bool shouldNotifyToIdle;
    };

    void InitializeCalculationContext(CalculationContext* pContext) NN_NOEXCEPT
    {
        pContext->shouldNotifyToIdle = true;
    }

    void CalculateStatus(Status* pOut, const CommonWindowProperty& commonProp, const Property& prop, CalculationContext* pContext) NN_NOEXCEPT
    {
        bool shouldSetHandlingContext = false;
        if (pContext->shouldNotifyToIdle)
        {
            if (prop.needsSetHandlingContext)
            {
                shouldSetHandlingContext = true;
                pContext->shouldNotifyToIdle = false;
                pOut->updateCount = prop.updateCount;
            }
            else if (commonProp.foregroundMode == ForegroundMode::All)
            {
                shouldSetHandlingContext = true;
                pContext->shouldNotifyToIdle = false;
                pOut->updateCount = prop.updateCount;
            }
        }
        pOut->shouldSetHandlingContext = shouldSetHandlingContext;
    }

    // 必要なものを定義(不要なものはコメントアウトすること)
    //static void UpdateNegativeImmediately(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT;
    //static void UpdateNegative(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT;
    static void UpdateImmediately(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT;
    //static void UpdatePositive(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT;
    //static void UpdatePositiveImmediately(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT;

    typedef Status EventStatus;

    struct EventType
    {
        bool onIdlePolicyChanged;
    };

    void HandleEvent(Window* p, const EventStatus& eventStatus, const EventType& e) NN_NOEXCEPT;

};

}}}}
