﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace am { namespace service { namespace window {

enum class WindowGlobalOrder : int
{
    ResourceReservation,
    Top,
    Overlay,
    ScreenLock,
    Normal,
    Bottom,
    Background,
};

enum class ForegroundMode : int
{
    None,
    Partial,
    All,
};

struct CommonWindowProperty
{
    WindowGlobalOrder globalOrder{WindowGlobalOrder::Normal};
    bool isMainAppletWindow;
    bool isOverlayAppletWindow;
    ForegroundMode foregroundMode;
};

}}}}
