﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Types.h>
#include <nn/os/os_MultipleWaitTypes.h>
#include <memory>
#include <nn/util/util_IntrusiveList.h>
#include <nn/os/os_Mutex.h>

#include <nn/applet/applet_Types.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>
#include <nn/ns/ns_ApplicationLaunchInfo.h>
#include <nn/ns/ns_ApplicationControlDataApi.h>

namespace nn { namespace am { namespace service { namespace process {

class NsProcess
{
public:

    virtual ~NsProcess() NN_NOEXCEPT {}

    virtual os::ProcessId GetProcessId() const NN_NOEXCEPT = 0;
    virtual void Terminate() NN_NOEXCEPT = 0;
    virtual void Join() NN_NOEXCEPT = 0;
    virtual void InitializeMultiWaitHolder(os::MultiWaitHolderType* pHolder) NN_NOEXCEPT = 0;

};

inline void InitializeMultiWaitHolder(os::MultiWaitHolderType* pHolder, NsProcess* p) NN_NOEXCEPT
{
    p->InitializeMultiWaitHolder(pHolder);
}

class AttachedNsProcess
    : public NsProcess
{
public:
    virtual os::ProcessId GetProcessId() const NN_NOEXCEPT NN_OVERRIDE;
    virtual void Terminate() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Join() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InitializeMultiWaitHolder(os::MultiWaitHolderType* pHolder) NN_NOEXCEPT NN_OVERRIDE;
};

class NsProcessManager
{
public:

    Result MakeLibraryAppletProcess(std::shared_ptr<NsProcess>* pOut, ncm::SystemProgramId id) NN_NOEXCEPT;
    Result MakeSystemAppletProcess(std::shared_ptr<NsProcess>* pOut) NN_NOEXCEPT;
    Result MakeOverlayAppletProcess(std::shared_ptr<NsProcess>* pOut) NN_NOEXCEPT;
    std::shared_ptr<NsProcess> MakeLibraryAppletProcess(os::ProcessId id) NN_NOEXCEPT;
    Result GetApplicationMainProgramIndex(uint8_t* pOut, const ns::ApplicationLaunchInfo& launchInfo) NN_NOEXCEPT;
    Result MakeApplicationProcess(std::shared_ptr<NsProcess>* pOut, ncm::ApplicationId id, uint8_t programIndex) NN_NOEXCEPT;
    std::shared_ptr<NsProcess> MakeApplicationProcess(os::ProcessId id) NN_NOEXCEPT;
    Result GetApplicationLaunchInfo(ns::ApplicationLaunchInfo* pOut, ncm::ApplicationId id) NN_NOEXCEPT;
    Result AcquireApplicationLaunchInfoForDevelop(ns::ApplicationLaunchInfo* pOut, os::ProcessId processId) NN_NOEXCEPT;
    Result GetApplicationControlProperty(ns::ApplicationControlProperty* pOut, const ns::ApplicationLaunchInfo& launchInfo, uint8_t programIndex) NN_NOEXCEPT;

    static Result GetApplicationIdByProcessId(ncm::ApplicationId* pOut, os::ProcessId processId) NN_NOEXCEPT;

    void NotifyExit(os::ProcessId processId) NN_NOEXCEPT;

private:

    class ProcessBase;
    typedef util::IntrusiveList<ProcessBase, util::IntrusiveListBaseNodeTraits<ProcessBase>> List;

    class LibraryAppletProcess;
    class ApplicationProcess;

    os::Mutex m_Mutex{false};
    List m_List;

    void Add(ProcessBase* p) NN_NOEXCEPT;

};

}}}}
