﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/capsrv/capsrv_ScreenShotOrientation.h>
#include "am_IntegratedDisplayLayerHandle.h"

namespace nn{ namespace am{ namespace service{ namespace display{

    class ScreenShotRequest
    {
    public:
        enum RequestType
        {
            RequestType_None = 0,
            RequestType_TakingScreenShot,
            RequestType_NotifyingRefused,
            RequestType_NotifyingFailure,
        };

    public:
        ScreenShotRequest() NN_NOEXCEPT
        {
            m_RequestType = RequestType_None;
            m_hLayer = {};
            m_ApplicationId = {};
            m_Orientation = {};
            m_RequestTick = nn::os::Tick();
            m_IsOpenUserIdListRequired = false;
        }

        static ScreenShotRequest GetTakingScreenShotRequest(
            IntegratedDisplayLayerHandle hLayer,
            nn::ncm::ApplicationId applicationId,
            nn::capsrv::ScreenShotOrientation orientation,
            nn::os::Tick requestTick,
            bool isOpenUserIdListRequired
        ) NN_NOEXCEPT
        {
            ScreenShotRequest value = {};
            value.m_RequestType   = RequestType_TakingScreenShot;
            value.m_hLayer        = hLayer;
            value.m_ApplicationId = applicationId;
            value.m_Orientation   = orientation;
            value.m_RequestTick   = requestTick;
            value.m_IsOpenUserIdListRequired = isOpenUserIdListRequired;
            return value;
        }

        static ScreenShotRequest GetNotifyingRefusedRequest(
            IntegratedDisplayLayerHandle hLayer,
            nn::ncm::ApplicationId applicationId,
            nn::os::Tick requestTick
        ) NN_NOEXCEPT
        {
            ScreenShotRequest value;
            value.m_RequestType  = RequestType_NotifyingRefused;
            value.m_hLayer        = hLayer;
            value.m_ApplicationId = applicationId;
            value.m_RequestTick   = requestTick;
            return value;
        }

        static ScreenShotRequest GetNotifyingFailureRequest(
            IntegratedDisplayLayerHandle hLayer,
            nn::ncm::ApplicationId applicationId,
            nn::os::Tick requestTick
        ) NN_NOEXCEPT
        {
            ScreenShotRequest value;
            value.m_RequestType  = RequestType_NotifyingFailure;
            value.m_hLayer        = hLayer;
            value.m_ApplicationId = applicationId;
            value.m_RequestTick   = requestTick;
            return value;
        }

        RequestType GetRequestType() const NN_NOEXCEPT { return m_RequestType; }
        IntegratedDisplayLayerHandle GetLayerHandle() const NN_NOEXCEPT { return m_hLayer; }
        nn::ncm::ApplicationId GetApplicationId() const NN_NOEXCEPT { return m_ApplicationId; }
        nn::capsrv::ScreenShotOrientation GetOrienation() const NN_NOEXCEPT { return m_Orientation; }
        nn::os::Tick GetRequestTick() const NN_NOEXCEPT { return m_RequestTick; }
        bool IsOpenUserIdListRequired() const NN_NOEXCEPT { return m_IsOpenUserIdListRequired; }

    private:
        RequestType                       m_RequestType;
        IntegratedDisplayLayerHandle      m_hLayer;
        nn::ncm::ApplicationId            m_ApplicationId;
        nn::capsrv::ScreenShotOrientation m_Orientation;
        nn::os::Tick                      m_RequestTick;
        bool                              m_IsOpenUserIdListRequired;
    };

}}}}
