﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/vi/manager/vi_Manager.h>

namespace nn{ namespace am{ namespace service{ namespace display{

    class MyDisplayManagerService
        : public vi::manager::DisplayManagerService
    {
    public:

        MyDisplayManagerService() NN_NOEXCEPT;
        ~MyDisplayManagerService() NN_NOEXCEPT;

        vi::DisplayId GetDisplayId() NN_NOEXCEPT;

    private:

        vi::DisplayId m_DisplayId;

    private:
        struct DisplayInfo
        {
            uint64_t        m_Name64;
            vi::DisplayId   m_DisplayId;
            uint64_t        m_OpenCount;
        };
        static const size_t DisplayTableMax = 10;
        DisplayInfo m_DisplayTable[DisplayTableMax];
        os::Mutex   m_DisplayTableMutex{false};

        static uint64_t MakeName64Value(const char* name) NN_NOEXCEPT;
        bool OpenByName(vi::DisplayId* pOutDisplayId, const char* name) NN_NOEXCEPT;
        void RegisterDisplayIdAndName(const char* name, vi::DisplayId id) NN_NOEXCEPT;
        uint64_t CloseByDisplayId(vi::DisplayId id) NN_NOEXCEPT;

    public:
        Result OpenDisplayWrapper(vi::DisplayId* pOutDisplayId, const char* displayName) NN_NOEXCEPT;
        Result CloseDisplayWrapper(vi::DisplayId displayId) NN_NOEXCEPT;
    };

}}}}
