﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/vi/vi_LayerStack.h>
#include <nn/vi/fbshare/vi_SharedMemoryPoolLayout.h>
#include <nn/vi/fbshare/vi_SharedLayerTextureIndexList.h>

namespace nn{ namespace am{ namespace service{ namespace display{

    static const nn::vi::LayerStackFlagType ApplicationCopyrightLayerStackFlags =
        (1 << nn::vi::LayerStack_Screenshot) |
        (1 << nn::vi::LayerStack_Recording);

    static const nn::vi::LayerStackFlagType OperationModeLayerStackFlags =
        (1 << nn::vi::LayerStack_Default);

    static const nn::vi::LayerStackFlagType TransitionLayerStackFlags =
        (1 << nn::vi::LayerStack_Default) |
        (1 << nn::vi::LayerStack_LastFrame);

    static const nn::vi::LayerStackFlagType NullLayerStackFlags =
        (1 << nn::vi::LayerStack_Null);

    struct IntegratedDisplayParameter
    {
    public:
        static IntegratedDisplayParameter GetValueForPureSharingMode() NN_NOEXCEPT;

    public:
        bool isBufferShaingEnabled;
        bool isImmediateCallerAppletCaptureForced;
        int transitionBufferIndex;
        int startupLogoBufferIndex;
        int operationModeBufferIndex;
        int lastApplicationBufferIndex;
        int lastForegroundBufferIndex;
        int callerAppletBufferIndex;
        int copyrightTemporalBufferIndex;
        nn::vi::fbshare::SharedLayerTextureIndexList indexForFullscreen;
        nn::vi::fbshare::SharedLayerTextureIndexList indexForPartial;
        nn::vi::fbshare::SharedMemoryPoolLayout layout;

        nn::TimeSpan indirectProducerFlipOffset;
        nn::TimeSpan sharedLayerDetachTimeout;
        nn::TimeSpan captureBufferTimeout;
    };

}}}}
