﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/nn_TimeSpan.h>

namespace nn { namespace am { namespace service {

enum GpuTimeKind
{
    GpuTimeKind_FgApp = 0,
    GpuTimeKind_BgApp = 1,
    GpuTimeKind_Oa = 2,
    GpuTimeKind_FgSa = 3,
    GpuTimeKind_BgSa = 4,
    GpuTimeKind_FgLa = 5,
    GpuTimeKind_PartialFgLa = 6,
    GpuTimeKind_BgLa = 7,

    GpuTimeKind_Count
};

enum GpuResourceGroupId
{
    GpuResourceGroupId_Application = 0,
    GpuResourceGroupId_System = 1,
    GpuResourceGroupId_Overlay = 2,

    GpuResourceGroupId_Count
};

bool IsGpuSchedulingEnabled() NN_NOEXCEPT;

TimeSpan GetGpuScheduleTimeSpan() NN_NOEXCEPT;

TimeSpan GetGpuTimeSliceOf(GpuTimeKind kind) NN_NOEXCEPT;

void StartGpuResourceControl() NN_NOEXCEPT;
void StopGpuResourceControl() NN_NOEXCEPT;

void RegisterToGpuResourceControl(GpuResourceGroupId groupId, applet::AppletResourceUserId aruid) NN_NOEXCEPT;
void UnregisterFromGpuResourceControl(GpuResourceGroupId groupId, applet::AppletResourceUserId aruid) NN_NOEXCEPT;

class GpuResourceControlInfo
{
private:

    bool m_IsSetAny{false};
    TimeSpan m_TimeSlices[GpuResourceGroupId_Count] = {};

public:

    void Add(GpuResourceGroupId groupId, TimeSpan timeSlice) NN_NOEXCEPT
    {
        this->m_IsSetAny = true;
        m_TimeSlices[groupId] += timeSlice;
    }

    bool IsSetAny() const NN_NOEXCEPT
    {
        return m_IsSetAny;
    }

    TimeSpan operator[](GpuResourceGroupId groupId) const NN_NOEXCEPT
    {
        return m_TimeSlices[groupId];
    }

    friend bool operator==(const GpuResourceControlInfo& lhs, const GpuResourceControlInfo& rhs) NN_NOEXCEPT
    {
        if (!(lhs.m_IsSetAny == rhs.m_IsSetAny))
        {
            return false;
        }
        for (int i = 0; i < GpuResourceGroupId_Count; ++i)
        {
            auto groupId = static_cast<GpuResourceGroupId>(i);
            if (!(lhs.m_TimeSlices[groupId] == rhs.m_TimeSlices[groupId]))
            {
                return false;
            }
        }
        return true;
    }

};

void SetGpuResourceControl(const GpuResourceControlInfo& info) NN_NOEXCEPT;

}}}
