﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/os/os_MultipleWait.h>

namespace nn { namespace am { namespace service {

class AppletSystem;

void InitializeGpuErrorControl() NN_NOEXCEPT;

void RegisterToGpuErrorControl(applet::AppletResourceUserId aruid) NN_NOEXCEPT;
void UnregisterToGpuErrorControl(applet::AppletResourceUserId aruid) NN_NOEXCEPT;

class GpuErrorEvent
{
public:

    explicit GpuErrorEvent() NN_NOEXCEPT;
    ~GpuErrorEvent() NN_NOEXCEPT;

    void LinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        os::LinkMultiWaitHolder(p, &m_Holder);
    }

    void UnlinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        NN_UNUSED(p);
        os::UnlinkMultiWaitHolder(&m_Holder);
    }

    bool HandleEventIfHolderOwner(os::MultiWaitHolderType* holder, AppletSystem* pAppletSystem)
    {
        if (holder == &m_Holder)
        {
            Handle(pAppletSystem);
            return true;
        }
        return false;
    }

    void OnMaybeProcessTerminated() NN_NOEXCEPT;

private:

    void Handle(AppletSystem* pAppletSystem) NN_NOEXCEPT;

private:

    os::MultiWaitHolderType m_Holder;

};


}}}
