﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/am/service/am_Proxies.sfdl.h>
#include <nn/am/service/am_AppletSystem.h>
#include <nn/am/service/am_CommonTypes.h>
#include <memory>

#include <list>
#include <nn/os/os_Mutex.h>
#include <nn/am/service/am_ServiceStaticAllocator.h>

namespace nn { namespace am { namespace service {

namespace process {

class AppletProxy;

}

class AppletService
{
public:

    // for SF
    nn::Result OpenApplicationProxy(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IApplicationProxy>> pOut, nn::Bit64 processId, sf::NativeHandle processHandle) NN_NOEXCEPT;
    nn::Result OpenSystemApplicationProxy(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IApplicationProxy>> pOut, nn::Bit64 processId, sf::NativeHandle processHandle) NN_NOEXCEPT;
    nn::Result OpenSystemAppletProxy(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::ISystemAppletProxy>> pOut, nn::Bit64 processId, sf::NativeHandle processHandle) NN_NOEXCEPT;
    nn::Result OpenLibraryAppletProxyOld(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::ILibraryAppletProxy>> pOut, nn::Bit64 processId, sf::NativeHandle processHandle) NN_NOEXCEPT;
    nn::Result OpenLibraryAppletProxy(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::ILibraryAppletProxy>> pOut, nn::Bit64 processId, sf::NativeHandle processHandle, const AppletAttribute& attribute) NN_NOEXCEPT;
    nn::Result OpenOverlayAppletProxy(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IOverlayAppletProxy>> pOut, nn::Bit64 processId, sf::NativeHandle processHandle) NN_NOEXCEPT;

    // for SF (develop)
    nn::Result CreateSelfLibraryAppletCreatorForDevelop(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::ILibraryAppletCreator>> pOut, nn::Bit64 processId) NN_NOEXCEPT;

    // for SF (develop)
    nn::Result GetSystemAppletControllerForDebug(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::ISystemAppletControllerForDebug>> pOut) NN_NOEXCEPT;

    void EventHandlerLoopAuto() NN_NOEXCEPT;
    void RunWindowManager() NN_NOEXCEPT;

    AppletSystem& GetAppletSystem() NN_NOEXCEPT;

private:

    // TORIAEZU: 埋め込み
    AppletSystem m_AppletSystem;

    template <typename Interface, typename AppletCreator>
    Result OpenProxyImpl(sf::Out<nn::sf::SharedPointer<Interface>> pOut, Bit64 processId, sf::NativeHandle processHandle, const ProxyOption& proxyOption, AppletCreator&& appletCreator, const AppletAttribute* pAttribute = nullptr) NN_NOEXCEPT;

};

}}}
