﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   アプレットのデバッグ機能に関する API の宣言
 *
 * @details
 *  本ヘッダでは、アプレットのデバッグ機能に関する API を定義しています。
 *
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/ae/ae_Types.h>


namespace nn { namespace ae {

//-----------------------------------------------------------------------------

//! @name アプレット制御のデバッグに関する API
//! @{

//--------------------------------------------------------------------------
/**
 * @brief   HOME ボタン押下（短押し）のメッセージを配信します。
 *
 * @pre
 *  - 以下のいずれかの状態である
 *    - システムアプレットとして実行中である
 *    - ライブラリアプレットとして実行中である
 *    - オーバーレイアプレットとして実行中である
 *
 * @details
 *  HOME ボタンが短押しされた場合と同じ Message_DetectShortPressingHomeButton
 *  メッセージを AppletId_SystemAppletMenu のアプレットに対して通知します。
 *
 *  本 API はデバッグ専用のため、将来的に削除される可能性があります。
 *
 */
void NotifyShortPressingHomeButtonForDebug() NN_NOEXCEPT;

//--------------------------------------------------------------------------
/**
 * @brief   HOME ボタン押下（長押し）のメッセージを配信します。
 *
 * @pre
 *  - 以下のいずれかの状態である
 *    - システムアプレットとして実行中である
 *    - ライブラリアプレットとして実行中である
 *    - オーバーレイアプレットとして実行中である
 *
 * @details
 *  HOME ボタンが長押しされた場合と同じ Message_DetectLongPressingHomeButton
 *  メッセージを AppletId_SystemAppletMenu のアプレットに対して通知します。
 *
 *  本 API はデバッグ専用のため、将来的に削除される可能性があります。
 *
 */
void NotifyLongPressingHomeButtonForDebug() NN_NOEXCEPT;

//--------------------------------------------------------------------------
/**
 * @brief   POWER ボタン押下（短押し）のメッセージを配信します。
 *
 * @pre
 *  - 以下のいずれかの状態である
 *    - システムアプレットとして実行中である
 *    - ライブラリアプレットとして実行中である
 *    - オーバーレイアプレットとして実行中である
 *
 * @details
 *  POWER ボタンが短押しされた場合と同じ Message_DetectShortPressingPowerButton
 *  メッセージを AppletId_SystemAppletMenu のアプレットに対して通知します。
 *
 *  本 API はデバッグ専用のため、将来的に削除される可能性があります。
 *
 */
void NotifyShortPressingPowerButtonForDebug() NN_NOEXCEPT;

//--------------------------------------------------------------------------
/**
 * @brief   POWER ボタン押下（中押し）のメッセージを配信します。
 *
 * @pre
 *  - 以下のいずれかの状態である
 *    - システムアプレットとして実行中である
 *    - ライブラリアプレットとして実行中である
 *    - オーバーレイアプレットとして実行中である
 *
 * @details
 *  POWER ボタンが中押しされた場合と同じ Message_DetectMiddlePressingPowerButton
 *  メッセージを AppletId_SystemAppletMenu のアプレットに対して通知します。
 *
 *  本 API はデバッグ専用のため、将来的に削除される可能性があります。
 *
 */
void NotifyMiddlePressingPowerButtonForDebug() NN_NOEXCEPT;

//--------------------------------------------------------------------------
/**
 * @brief   POWER ボタン押下（長押し）のメッセージを配信します。
 *
 * @pre
 *  - 以下のいずれかの状態である
 *    - システムアプレットとして実行中である
 *    - ライブラリアプレットとして実行中である
 *    - オーバーレイアプレットとして実行中である
 *
 * @details
 *  POWER ボタンが長押しされた場合と同じ Message_DetectLongPressingPowerButton
 *  メッセージを AppletId_SystemAppletMenu のアプレットに対して通知します。
 *
 *  本 API はデバッグ専用のため、将来的に削除される可能性があります。
 *
 */
void NotifyLongPressingPowerButtonForDebug() NN_NOEXCEPT;

/**
    @brief (partial LA 開発専用) 遷移レイヤを強制的に非表示にします。

    @details
     partial LA のレイヤが表示されない不具合の回避のために、
     遷移レイヤを強制的に非表示とします。

     目的外の使用はしないでください。
*/

void InvalidateTransitionLayerForDevelop() NN_NOEXCEPT;

//! @}

//-----------------------------------------------------------------------------

}} // namespace nn::ae

