﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/account/profile/account_ProfileTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace account { namespace profile { // NOLINT(whitespace/braces)

class IProfile;

class IProfileEditor;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IProfile, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IProfile)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Get, (::nn::sf::Out<::nn::account::profile::ProfileBase> pOutProfileBase, ::nn::sf::Out<::nn::account::profile::UserData> pOutUserData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBase, (::nn::sf::Out<::nn::account::profile::ProfileBase> pOutProfileBase))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetImageSize, (::nn::sf::Out<::std::uint32_t> pOutSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadImage, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOutImage))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IProfile)

        ::nn::Result Get(::nn::sf::Out<::nn::account::profile::ProfileBase> pOutProfileBase, ::nn::sf::Out<::nn::account::profile::UserData> pOutUserData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Get, (pOutProfileBase, pOutUserData));
        }

        ::nn::Result GetBase(::nn::sf::Out<::nn::account::profile::ProfileBase> pOutProfileBase) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBase, (pOutProfileBase));
        }

        ::nn::Result GetImageSize(::nn::sf::Out<::std::uint32_t> pOutSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetImageSize, (pOutSize));
        }

        ::nn::Result LoadImage(::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), pOutImage)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = pOutImage)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadImage, (pOutActualSize, pOutImage));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IProfile
    {
    public:
        nn::Result Get(nn::sf::Out<nn::account::profile::ProfileBase> pOutProfileBase, nn::sf::Out<nn::account::profile::UserData> pOutUserData) NN_NOEXCEPT;
        nn::Result GetBase(nn::sf::Out<nn::account::profile::ProfileBase> pOutProfileBase) NN_NOEXCEPT;
        nn::Result GetImageSize(nn::sf::Out<std::uint32_t> pOutSize) NN_NOEXCEPT;
        nn::Result LoadImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Get(nn::sf::Out<nn::account::profile::ProfileBase> pOutProfileBase, nn::sf::Out<nn::account::profile::UserData> pOutUserData) NN_NOEXCEPT;
    nn::Result GetBase(nn::sf::Out<nn::account::profile::ProfileBase> pOutProfileBase) NN_NOEXCEPT;
    nn::Result GetImageSize(nn::sf::Out<std::uint32_t> pOutSize) NN_NOEXCEPT;
    nn::Result LoadImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::account::profile::IProfile))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get, (::nn::sf::Out<::nn::account::profile::ProfileBase> pOutProfileBase, ::nn::sf::Out<::nn::account::profile::UserData> pOutUserData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Get, (pOutProfileBase, pOutUserData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBase, (::nn::sf::Out<::nn::account::profile::ProfileBase> pOutProfileBase))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBase, (pOutProfileBase));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetImageSize, (::nn::sf::Out<::std::uint32_t> pOutSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetImageSize, (pOutSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadImage, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOutImage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadImage, (pOutActualSize, pOutImage));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::profile::IProfile>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::account::profile::IProfile))

    // nn::Result Get(nn::sf::Out<nn::account::profile::ProfileBase> pOutProfileBase, nn::sf::Out<nn::account::profile::UserData> pOutUserData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Get)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutUserData, 0, (::nn::sf::Out<::nn::account::profile::UserData>), 128, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutUserData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutProfileBase, (::nn::account::profile::ProfileBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutProfileBase))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutProfileBase), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutUserData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Get)

    // nn::Result GetBase(nn::sf::Out<nn::account::profile::ProfileBase> pOutProfileBase) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBase)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutProfileBase, (::nn::account::profile::ProfileBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutProfileBase))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutProfileBase)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBase)

    // nn::Result GetImageSize(nn::sf::Out<std::uint32_t> pOutSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetImageSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetImageSize)

    // nn::Result LoadImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutImage, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutImage))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutActualSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutActualSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutActualSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutImage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadImage)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::profile::ProfileBase), 56, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::profile::UserData), 128, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::profile::IProfile, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::account::profile::IProfile))

    // nn::Result Get(nn::sf::Out<nn::account::profile::ProfileBase> pOutProfileBase, nn::sf::Out<nn::account::profile::UserData> pOutUserData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get, (::nn::sf::Out<::nn::account::profile::ProfileBase> pOutProfileBase, ::nn::sf::Out<::nn::account::profile::UserData> pOutUserData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Get)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutProfileBase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutUserData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Get)
    }

    // nn::Result GetBase(nn::sf::Out<nn::account::profile::ProfileBase> pOutProfileBase) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBase, (::nn::sf::Out<::nn::account::profile::ProfileBase> pOutProfileBase))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutProfileBase)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBase)
    }

    // nn::Result GetImageSize(nn::sf::Out<std::uint32_t> pOutSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetImageSize, (::nn::sf::Out<::std::uint32_t> pOutSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetImageSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetImageSize)
    }

    // nn::Result LoadImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadImage, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOutImage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutActualSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutImage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadImage)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::profile::IProfile>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::account::profile::IProfile))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Get)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutUserData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Get)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutProfileBase),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutUserData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBase)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutProfileBase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetImageSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetImageSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutImage)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutActualSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Get)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetImageSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadImage)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::profile::IProfile))

namespace nn { namespace account { namespace profile { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IProfileEditor, (::nn::account::profile::IProfile))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IProfileEditor)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Store, (const ::nn::account::profile::ProfileBase& profileBase, const ::nn::account::profile::UserData& userData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StoreWithImage, (const ::nn::account::profile::ProfileBase& profileBase, const ::nn::account::profile::UserData& userData, const ::nn::sf::InBuffer& pImage))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IProfileEditor)

        ::nn::Result Store(const ::nn::account::profile::ProfileBase& profileBase, const ::nn::account::profile::UserData& userData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), profileBase)), "static_cast<bool>(_) (where _ = profileBase)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Store, (profileBase, userData));
        }

        ::nn::Result StoreWithImage(const ::nn::account::profile::ProfileBase& profileBase, const ::nn::account::profile::UserData& userData, const ::nn::sf::InBuffer& pImage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), profileBase)), "static_cast<bool>(_) (where _ = profileBase)")
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), pImage)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = pImage)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StoreWithImage, (profileBase, userData, pImage));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IProfileEditor : public ::nn::account::profile::IProfile
    {
    public:
        nn::Result Store(const nn::account::profile::ProfileBase& profileBase, const nn::account::profile::UserData& userData) NN_NOEXCEPT;
        nn::Result StoreWithImage(const nn::account::profile::ProfileBase& profileBase, const nn::account::profile::UserData& userData, const nn::sf::InBuffer& pImage) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Get(nn::sf::Out<nn::account::profile::ProfileBase> pOutProfileBase, nn::sf::Out<nn::account::profile::UserData> pOutUserData) NN_NOEXCEPT;
    nn::Result GetBase(nn::sf::Out<nn::account::profile::ProfileBase> pOutProfileBase) NN_NOEXCEPT;
    nn::Result GetImageSize(nn::sf::Out<std::uint32_t> pOutSize) NN_NOEXCEPT;
    nn::Result LoadImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT;
    nn::Result Store(const nn::account::profile::ProfileBase& profileBase, const nn::account::profile::UserData& userData) NN_NOEXCEPT;
    nn::Result StoreWithImage(const nn::account::profile::ProfileBase& profileBase, const nn::account::profile::UserData& userData, const nn::sf::InBuffer& pImage) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::account::profile::IProfileEditor), (::nn::account::profile::IProfile))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Store, (const ::nn::account::profile::ProfileBase& profileBase, const ::nn::account::profile::UserData& userData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Store, (profileBase, userData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StoreWithImage, (const ::nn::account::profile::ProfileBase& profileBase, const ::nn::account::profile::UserData& userData, const ::nn::sf::InBuffer& pImage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StoreWithImage, (profileBase, userData, pImage));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::profile::IProfileEditor>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::account::profile::IProfileEditor), (::nn::account::profile::IProfile))

    // nn::Result Store(const nn::account::profile::ProfileBase& profileBase, const nn::account::profile::UserData& userData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Store)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(userData, 0, (const ::nn::account::profile::UserData&), 128, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (userData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(profileBase, (::nn::account::profile::ProfileBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (profileBase))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(profileBase), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Store)

    // nn::Result StoreWithImage(const nn::account::profile::ProfileBase& profileBase, const nn::account::profile::UserData& userData, const nn::sf::InBuffer& pImage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StoreWithImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(userData, 0, (const ::nn::account::profile::UserData&), 128, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pImage, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (userData, pImage))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(profileBase, (::nn::account::profile::ProfileBase), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (profileBase))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(profileBase), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pImage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StoreWithImage)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::profile::ProfileBase), 56, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::profile::UserData), 128, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::profile::IProfileEditor, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::account::profile::IProfileEditor), (::nn::account::profile::IProfile))

    // nn::Result Store(const nn::account::profile::ProfileBase& profileBase, const nn::account::profile::UserData& userData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Store, (const ::nn::account::profile::ProfileBase& profileBase, const ::nn::account::profile::UserData& userData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Store)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(profileBase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Store)
    }

    // nn::Result StoreWithImage(const nn::account::profile::ProfileBase& profileBase, const nn::account::profile::UserData& userData, const nn::sf::InBuffer& pImage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StoreWithImage, (const ::nn::account::profile::ProfileBase& profileBase, const ::nn::account::profile::UserData& userData, const ::nn::sf::InBuffer& pImage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StoreWithImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(profileBase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pImage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StoreWithImage)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::profile::IProfileEditor>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::account::profile::IProfileEditor), (::nn::account::profile::IProfile))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Store)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(userData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(profileBase)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Store)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(profileBase),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(userData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StoreWithImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(userData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(profileBase)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pImage)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StoreWithImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(profileBase),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(userData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Store)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StoreWithImage)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::profile::IProfileEditor))
