﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/http/stream/http_WebApiAccessorBase.h>

namespace nn { namespace account { namespace http {

class RedirectionCaptor
    : nn::http::stream::WebApiAccessorBase
{
    NN_DISALLOW_COPY(RedirectionCaptor);

private:
    std::atomic<bool> m_InProcess {false};
    Result m_IoResult {ResultSuccess()};

    struct
    {
        char* address;
        size_t total;
        size_t used;
    } m_BufferInfo {nullptr, 0u, 0u};

    static size_t HeaderFunction(char* ptr, size_t unitBytes, size_t count, void* pContext) NN_NOEXCEPT;
    static size_t WriteFunction(char* ptr, size_t unitBytes, size_t count, void* pContext) NN_NOEXCEPT;

public:
    RedirectionCaptor(CURL* curlHandle, const util::Cancelable* pCancellable = nullptr) NN_NOEXCEPT;

    Result Initialize(char* buffer, size_t bufferSize) NN_NOEXCEPT;

    using WebApiAccessorBase::SetUrl;
    using WebApiAccessorBase::SetHeaders;
    using WebApiAccessorBase::SetHttpPost;
    using WebApiAccessorBase::SetDebugMode;

    Result Invoke() NN_NOEXCEPT;
    const char* GetLocation() const NN_NOEXCEPT;
};

}}} // ~namespace nn::account::http
